/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd;

import com.feed_the_beast.ftbl.api.cmd.CommandLM;
import com.feed_the_beast.ftbl.api.cmd.CommandSubBase;
import com.feed_the_beast.ftbl.util.BroadcastSender;
import com.feed_the_beast.ftbu.FTBULang;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.world.backups.Backups;
import com.latmod.lib.util.LMFileUtils;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class CmdBackup
extends CommandSubBase {
    public CmdBackup() {
        super("backup");
        this.add((ICommand)new CmdBackupStart());
        this.add((ICommand)new CmdBackupStop());
        this.add((ICommand)new CmdBackupGetSize());
    }

    public static class CmdBackupGetSize
    extends CommandLM {
        public CmdBackupGetSize() {
            super("getsize");
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender ics, @Nonnull String[] args) throws CommandException {
            String sizeW = LMFileUtils.getSizeS((File)ics.func_130014_f_().func_72860_G().func_75765_b());
            String sizeT = LMFileUtils.getSizeS((File)Backups.backupsFolder);
            FTBULang.backup_size.printChat(ics, new Object[]{sizeW, sizeT});
        }
    }

    public static class CmdBackupStop
    extends CommandLM {
        public CmdBackupStop() {
            super("stop");
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender ics, @Nonnull String[] args) throws CommandException {
            if (Backups.thread != null) {
                Backups.thread.interrupt();
                Backups.thread = null;
                FTBULang.backup_stop.printChat(ics, new Object[0]);
                return;
            }
            throw FTBULang.backup_not_running.commandError(new Object[0]);
        }
    }

    public static class CmdBackupStart
    extends CommandLM {
        public CmdBackupStart() {
            super("start");
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender ics, @Nonnull String[] args) throws CommandException {
            boolean b = Backups.run(ics);
            if (b) {
                FTBULang.backup_manual_launch.printChat((ICommandSender)BroadcastSender.inst, new Object[]{ics.func_70005_c_()});
                if (!FTBUConfigBackups.use_separate_thread.getAsBoolean()) {
                    Backups.postBackup();
                }
            } else {
                FTBULang.backup_already_running.printChat(ics, new Object[0]);
            }
        }
    }
}

