/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.cmd.CommandLM;
import com.feed_the_beast.ftbl.api.cmd.CommandSubBase;
import com.feed_the_beast.ftbl.api.notification.Notification;
import com.feed_the_beast.ftbl.api.permissions.Context;
import com.feed_the_beast.ftbl.api.permissions.PermissionAPI;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbu.net.MessageAreaUpdate;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataMP;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CmdChunks
extends CommandSubBase {
    public CmdChunks() {
        super("chunks");
        this.add((ICommand)new CmdClaim());
        this.add((ICommand)new CmdUnclaim());
        this.add((ICommand)new CmdLoad());
        this.add((ICommand)new CmdUnload());
        this.add((ICommand)new CmdUnclaimAll());
        this.add((ICommand)new CmdUnloadAll());
        this.add((ICommand)new CmdAdminUnclaimAll());
    }

    public int func_82362_a() {
        return 0;
    }

    public class CmdAdminUnclaimAll
    extends CommandLM {
        public CmdAdminUnclaimAll() {
            super("admin_unclaim_all");
        }

        @Nonnull
        public String func_71518_a(@Nonnull ICommandSender ics) {
            return '/' + this.commandName + " <player | @a>";
        }

        public boolean func_82358_a(String[] args, int i) {
            return i == 0;
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender ics, @Nonnull String[] args) throws CommandException {
            CmdAdminUnclaimAll.checkArgs((String[])args, (int)1, (String)"<player>");
            ForgePlayerMP p = ForgePlayerMP.get((Object)args[0]);
            FTBUWorldDataMP.unclaimAllChunks(p, null);
            ics.func_145747_a((ITextComponent)new TextComponentString("Unclaimed all " + p.getProfile().getName() + "'s chunks"));
        }
    }

    public class CmdUnloadAll
    extends CommandLM {
        public CmdUnloadAll() {
            super("admin_unload_all");
        }

        public boolean func_82358_a(String[] args, int i) {
            return i == 0;
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender ics, @Nonnull String[] args) throws CommandException {
            CmdUnloadAll.checkArgs((String[])args, (int)1, (String)"<player>");
            if (args[0].equals("@a")) {
                for (ClaimedChunk c : FTBUWorldDataMP.chunks.getAllChunks()) {
                    c.loaded = false;
                }
                for (ForgePlayer p : ForgeWorldMP.inst.getOnlinePlayers()) {
                    p.toMP().sendUpdate();
                }
                ics.func_145747_a((ITextComponent)new TextComponentString("Unloaded all chunks"));
                return;
            }
            ForgePlayerMP p = ForgePlayerMP.get((Object)args[0]);
            for (ClaimedChunk c : FTBUWorldDataMP.chunks.getChunks(p.getProfile().getId())) {
                c.loaded = false;
            }
            if (p.isOnline()) {
                p.sendUpdate();
            }
            ics.func_145747_a((ITextComponent)new TextComponentString("Unloaded all " + p.getProfile().getName() + "'s chunks"));
        }
    }

    public class CmdUnclaimAll
    extends CommandLM {
        public CmdUnclaimAll() {
            super("unclaim_all");
        }

        public int func_82362_a() {
            return 0;
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            ForgePlayerMP p;
            EntityPlayerMP ep = CmdUnclaimAll.func_71521_c((ICommandSender)sender);
            CmdUnclaimAll.checkArgs((String[])args, (int)1, (String)"<all_dimensions> [player]");
            if (args.length >= 2) {
                if (!PermissionAPI.hasPermission((GameProfile)ep.func_146103_bH(), (String)"ftbu.claims.modify_other_chunks", (boolean)false, (Context)new Context((Entity)ep))) {
                    throw new CommandException("commands.generic.permission", new Object[0]);
                }
                p = ForgePlayerMP.get((Object)args[1]);
            } else {
                p = ForgePlayerMP.get((Object)ep);
            }
            FTBUWorldDataMP.unclaimAllChunks(p, CmdUnclaimAll.func_180527_d((String)args[0]) ? null : Integer.valueOf(ep.field_71093_bK));
            new Notification("unclaimed_all").addText((ITextComponent)new TextComponentString("Unclaimed all chunks")).sendTo(ep);
        }
    }

    public class CmdUnload
    extends CommandLM {
        public CmdUnload() {
            super("unload");
        }

        public int func_82362_a() {
            return 0;
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            ChunkDimPos pos;
            EntityPlayerMP ep = CmdUnload.func_71521_c((ICommandSender)sender);
            ForgePlayerMP p = ForgePlayerMP.get((Object)ep);
            if (FTBUWorldDataMP.setLoaded(p, pos = args.length >= 2 ? new ChunkDimPos(ep.field_71093_bK, CmdUnload.func_175755_a((String)args[0]), CmdUnload.func_175755_a((String)args[1])) : p.getPos().toChunkPos(), false)) {
                new Notification("modify_chunk").addText((ITextComponent)new TextComponentString("Chunk Unloaded")).sendTo(ep);
                new MessageAreaUpdate(pos.field_77276_a, pos.field_77275_b, pos.dim, 1, 1).sendTo(ep);
            } else {
                Notification.error((String)"modify_chunk", (ITextComponent)new TextComponentString("Can't modify this chunk!")).sendTo(ep);
            }
        }
    }

    public class CmdLoad
    extends CommandLM {
        public CmdLoad() {
            super("load");
        }

        public int func_82362_a() {
            return 0;
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            ChunkDimPos pos;
            EntityPlayerMP ep = CmdLoad.func_71521_c((ICommandSender)sender);
            ForgePlayerMP p = ForgePlayerMP.get((Object)ep);
            if (FTBUWorldDataMP.setLoaded(p, pos = args.length >= 2 ? new ChunkDimPos(ep.field_71093_bK, CmdLoad.func_175755_a((String)args[0]), CmdLoad.func_175755_a((String)args[1])) : p.getPos().toChunkPos(), true)) {
                new Notification("modify_chunk").addText((ITextComponent)new TextComponentString("Chunk Loaded")).sendTo(ep);
                new MessageAreaUpdate(pos.field_77276_a, pos.field_77275_b, pos.dim, 1, 1).sendTo(ep);
            } else {
                Notification.error((String)"modify_chunk", (ITextComponent)new TextComponentString("Can't modify this chunk!")).sendTo(ep);
            }
        }
    }

    public class CmdUnclaim
    extends CommandLM {
        public CmdUnclaim() {
            super("unclaim");
        }

        public int func_82362_a() {
            return 0;
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            ChunkDimPos pos;
            EntityPlayerMP ep = CmdUnclaim.func_71521_c((ICommandSender)sender);
            ForgePlayerMP p = ForgePlayerMP.get((Object)ep);
            if (!p.equalsPlayer(FTBUWorldDataMP.chunks.getOwnerPlayer(pos = args.length >= 2 ? new ChunkDimPos(ep.field_71093_bK, CmdUnclaim.func_175755_a((String)args[0]), CmdUnclaim.func_175755_a((String)args[1])) : p.getPos().toChunkPos())) && !PermissionAPI.hasPermission((GameProfile)ep.func_146103_bH(), (String)"ftbu.claims.modify_other_chunks", (boolean)false, (Context)new Context((Entity)ep).setCustomObject("chunk", (Object)pos))) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            if (FTBUWorldDataMP.unclaimChunk(p, pos)) {
                new Notification("modify_chunk").addText((ITextComponent)new TextComponentString("Chunk Unclaimed")).sendTo(ep);
                new MessageAreaUpdate(pos.field_77276_a, pos.field_77275_b, pos.dim, 1, 1).sendTo(ep);
            } else {
                Notification.error((String)"modify_chunk", (ITextComponent)new TextComponentString("Can't modify this chunk!")).sendTo(ep);
            }
        }
    }

    public class CmdClaim
    extends CommandLM {
        public CmdClaim() {
            super("claim");
        }

        public int func_82362_a() {
            return 0;
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            ChunkDimPos pos;
            EntityPlayerMP ep = CmdClaim.func_71521_c((ICommandSender)sender);
            ForgePlayerMP p = ForgePlayerMP.get((Object)ep);
            if (FTBUWorldDataMP.claimChunk(p, pos = args.length >= 2 ? new ChunkDimPos(ep.field_71093_bK, CmdClaim.func_175755_a((String)args[0]), CmdClaim.func_175755_a((String)args[1])) : p.getPos().toChunkPos())) {
                new Notification("modify_chunk").addText((ITextComponent)new TextComponentString("Chunk Claimed")).sendTo(ep);
                new MessageAreaUpdate(pos.field_77276_a, pos.field_77275_b, pos.dim, 1, 1).sendTo(ep);
            } else {
                Notification.error((String)"modify_chunk", (ITextComponent)new TextComponentString("Can't modify this chunk!")).sendTo(ep);
            }
        }
    }
}

