/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.config;

import com.feed_the_beast.ftbl.api.config.ConfigEntryBool;
import com.feed_the_beast.ftbl.api.config.ConfigEntryDouble;
import com.feed_the_beast.ftbl.api.config.ConfigEntryInt;
import com.feed_the_beast.ftbl.api.config.ConfigEntryString;
import com.latmod.lib.annotations.Info;
import com.latmod.lib.annotations.NumberBounds;

public class FTBUConfigBackups {
    public static final ConfigEntryBool enabled = new ConfigEntryBool(true);
    @NumberBounds(min=0.0, max=100.0)
    @Info(value={"The number of backup files to keep", "More backups = more space used", "0 - Disabled"})
    public static final ConfigEntryInt backups_to_keep = new ConfigEntryInt(12);
    @NumberBounds(min=0.05, max=600.0)
    @Info(value={"Timer in hours", "1.0 - backups every hour", "6.0 - backups every 6 hours", "0.5 - backups every 30 minutes"})
    public static final ConfigEntryDouble backup_timer = new ConfigEntryDouble(2.0);
    @NumberBounds(min=0.0, max=9.0)
    @Info(value={"0 - Disabled (output = folders)", "1 - Best speed", "9 - Smallest file size"})
    public static final ConfigEntryInt compression_level = new ConfigEntryInt(1);
    @Info(value={"Absolute path to backups folder"})
    public static final ConfigEntryString folder = new ConfigEntryString("");
    @Info(value={"Prints (current size | total size) when backup is done"})
    public static final ConfigEntryBool display_file_size = new ConfigEntryBool(true);
    @Info(value={"Run backup in a separated Thread (recommended)"})
    public static final ConfigEntryBool use_separate_thread = new ConfigEntryBool(true);
    @Info(value={"Backups won't run if no players had been online"})
    public static final ConfigEntryBool need_online_players = new ConfigEntryBool(true);

    public static long backupMillis() {
        return (long)((double)backup_timer.getAsInt() * 3600.0 * 1000.0);
    }
}

