/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerSPSelf;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.gui.GuiIcons;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.GuiLang;
import com.feed_the_beast.ftbl.api.client.gui.widgets.ButtonLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.PanelLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.WidgetLM;
import com.feed_the_beast.ftbl.net.MessageRequestSelfUpdate;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbl.util.TextureCoords;
import com.feed_the_beast.ftbu.FTBULang;
import com.feed_the_beast.ftbu.gui.ThreadReloadArea;
import com.feed_the_beast.ftbu.net.MessageAreaRequest;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.data.FTBUPlayerData;
import com.feed_the_beast.ftbu.world.data.FTBUPlayerDataSP;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataSP;
import com.latmod.lib.math.MathHelperLM;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiClaimChunks
extends GuiLM
implements GuiYesNoCallback {
    public static final int tiles_tex = 16;
    public static final int tiles_gui = 15;
    public static final double UV = 0.9375;
    public static final ResourceLocation TEX_ENTITY = new ResourceLocation("ftbu", "textures/gui/entity.png");
    public static final ResourceLocation TEX_CHUNK_CLAIMING = new ResourceLocation("ftbu", "textures/gui/chunk_claiming.png");
    public static final TextureCoords TEX_FILLED = new TextureCoords(TEX_CHUNK_CLAIMING, 0.0, 0.0, 0.5, 1.0);
    public static final TextureCoords TEX_BORDER = new TextureCoords(TEX_CHUNK_CLAIMING, 0.5, 0.0, 1.0, 1.0);
    public static int textureID = -1;
    public static ByteBuffer pixelBuffer = null;
    public final ForgePlayerSPSelf playerLM;
    public final int startX;
    public final int startZ;
    public final int currentDim;
    public final ButtonLM buttonRefresh;
    public final ButtonLM buttonClose;
    public final ButtonLM buttonUnclaimAll;
    public final MapButton[] mapButtons;
    public final PanelLM panelButtons;
    public ThreadReloadArea thread = null;
    public String currentDimName;

    public GuiClaimChunks(long token) {
        this.height = 240.0;
        this.width = 240.0;
        this.playerLM = ForgeWorldSP.inst.clientPlayer;
        this.startX = MathHelperLM.chunk((double)this.mc.field_71439_g.field_70165_t) - 7;
        this.startZ = MathHelperLM.chunk((double)this.mc.field_71439_g.field_70161_v) - 7;
        this.currentDim = FTBLibClient.getDim();
        this.currentDimName = this.mc.field_71441_e.field_73011_w.func_186058_p().func_186065_b();
        this.buttonClose = new ButtonLM(0.0, 0.0, 16.0, 16.0, GuiLang.button_close.translate()){

            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiLM.playClickSound();
                GuiClaimChunks.this.closeGui();
            }
        };
        this.buttonRefresh = new ButtonLM(0.0, 16.0, 16.0, 16.0, GuiLang.button_refresh.translate()){

            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiClaimChunks.this.thread = new ThreadReloadArea((World)GuiClaimChunks.this.mc.field_71441_e, GuiClaimChunks.this);
                GuiClaimChunks.this.thread.start();
                new MessageAreaRequest(GuiClaimChunks.this.startX, GuiClaimChunks.this.startZ, 15, 15).sendToServer();
                new MessageRequestSelfUpdate().sendToServer();
                GuiLM.playClickSound();
            }
        };
        this.buttonUnclaimAll = new ButtonLM(0.0, 32.0, 16.0, 16.0){

            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiLM.playClickSound();
                String s = GuiScreen.func_146272_n() ? FTBULang.button_claims_unclaim_all_q.translate() : FTBULang.button_claims_unclaim_all_dim_q.translateFormatted(new Object[]{GuiClaimChunks.this.currentDimName});
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)GuiClaimChunks.this, s, "", GuiScreen.func_146272_n() ? 1 : 0));
            }

            public void addMouseOverText(GuiLM gui, List<String> l) {
                l.add(GuiScreen.func_146272_n() ? FTBULang.button_claims_unclaim_all.translate() : FTBULang.button_claims_unclaim_all_dim.translateFormatted(new Object[]{GuiClaimChunks.this.currentDimName}));
            }
        };
        this.panelButtons = new PanelLM(0, 0, 16, 0){

            public void addWidgets() {
                this.add((WidgetLM)GuiClaimChunks.this.buttonClose);
                this.add((WidgetLM)GuiClaimChunks.this.buttonRefresh);
                this.add((WidgetLM)GuiClaimChunks.this.buttonUnclaimAll);
                this.height = this.widgets.size() * 16;
            }

            public double getAX() {
                return GuiClaimChunks.this.screen.func_78327_c() - 16.0;
            }

            public double getAY() {
                return 0.0;
            }
        };
        this.mapButtons = new MapButton[225];
        for (int i = 0; i < this.mapButtons.length; ++i) {
            this.mapButtons[i] = new MapButton(0, 0, i);
        }
    }

    public void onInit() {
        this.buttonRefresh.onClicked((GuiLM)this, MouseButton.LEFT);
    }

    public void addWidgets() {
        for (MapButton b : this.mapButtons) {
            this.add((WidgetLM)b);
        }
        this.add((WidgetLM)this.panelButtons);
    }

    public void drawBackground() {
        super.drawBackground();
        if (textureID == -1) {
            textureID = TextureUtil.func_110996_a();
            new MessageAreaRequest(this.startX, this.startZ, 15, 15).sendToServer();
        }
        if (pixelBuffer != null) {
            GlStateManager.func_179144_i((int)textureID);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)256, (int)256, (int)0, (int)6408, (int)5121, (ByteBuffer)pixelBuffer);
            pixelBuffer = null;
            this.thread = null;
        }
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiClaimChunks.drawBlankRect((double)(this.posX - 2.0), (double)(this.posY - 2.0), (double)(this.width + 4.0), (double)(this.height + 4.0));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.thread == null) {
            GlStateManager.func_179144_i((int)textureID);
            GuiClaimChunks.drawTexturedRect((double)this.posX, (double)this.posY, (double)240.0, (double)240.0, (double)0.0, (double)0.0, (double)0.9375, (double)0.9375);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        FTBLibClient.setTexture((ResourceLocation)TEX_CHUNK_CLAIMING);
        for (MapButton mapButton : this.mapButtons) {
            mapButton.renderWidget(this);
        }
        int cx = MathHelperLM.chunk((double)this.mc.field_71439_g.field_70165_t);
        int cy = MathHelperLM.chunk((double)this.mc.field_71439_g.field_70161_v);
        if (cx >= this.startX && cy >= this.startZ && cx < this.startX + 15 && cy < this.startZ + 15) {
            double x = (double)(cx - this.startX) * 16.0 + MathHelperLM.wrap((double)this.mc.field_71439_g.field_70165_t, (double)16.0);
            double y = (double)(cy - this.startZ) * 16.0 + MathHelperLM.wrap((double)this.mc.field_71439_g.field_70161_v, (double)16.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(this.posX + x), (double)(this.posY + y), (double)0.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(this.mc.field_71439_g.field_70177_z + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            FTBLibClient.setTexture((ResourceLocation)TEX_ENTITY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.mc.field_71439_g.func_70093_af() ? 0.4f : 0.7f));
            GuiClaimChunks.drawTexturedRect((double)-8.0, (double)-8.0, (double)16.0, (double)16.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
            GlStateManager.func_179121_F();
            GuiClaimChunks.drawPlayerHead((String)this.mc.field_71439_g.func_70005_c_(), (double)-2.0, (double)-2.0, (double)4.0, (double)4.0);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buttonRefresh.render(GuiIcons.refresh);
        this.buttonClose.render(GuiIcons.accept);
        this.buttonUnclaimAll.render(GuiIcons.remove);
    }

    public void drawForeground() {
        if (ForgeWorldSP.inst != null && ForgeWorldSP.inst.clientPlayer != null) {
            FTBUPlayerDataSP d = FTBUPlayerData.get((ForgePlayer)ForgeWorldSP.inst.clientPlayer).toSP();
            String s = FTBULang.label_cchunks_count.translateFormatted(new Object[]{d.claimedChunks + " / " + d.maxClaimedChunks});
            this.font.func_78276_b(s, this.screen.func_78326_a() - this.font.func_78256_a(s) - 4, this.screen.func_78328_b() - 12, -1);
            s = FTBULang.label_lchunks_count.translateFormatted(new Object[]{d.loadedChunks + " / " + d.maxLoadedChunks});
            this.font.func_78276_b(s, this.screen.func_78326_a() - this.font.func_78256_a(s) - 4, this.screen.func_78328_b() - 24, -1);
        }
        super.drawForeground();
    }

    public void func_73878_a(boolean set, int id) {
        if (set) {
            if (id == 1) {
                FTBLibClient.execClientCommand((String)"/ftb chunks unclaim_all true", (boolean)false);
            } else {
                FTBLibClient.execClientCommand((String)"/ftb chunks unclaim_all false", (boolean)false);
            }
            new MessageAreaRequest(this.startX, this.startZ, 15, 15).sendToServer();
        }
        this.openGui();
        this.refreshWidgets();
    }

    public class MapButton
    extends ButtonLM {
        public final ChunkDimPos chunkPos;

        public MapButton(int x, int y, int i) {
            super((double)x, (double)y, 16.0, 16.0);
            this.posX += (double)(i % 15) * this.width;
            this.posY += (double)(i / 15) * this.height;
            this.chunkPos = new ChunkDimPos(GuiClaimChunks.this.currentDim, GuiClaimChunks.this.startX + i % 15, GuiClaimChunks.this.startZ + i / 15);
        }

        public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
            if (gui.isMouseOver((WidgetLM)GuiClaimChunks.this.panelButtons)) {
                return;
            }
            if (button.isLeft()) {
                if (GuiScreen.func_146272_n()) {
                    FTBLibClient.execClientCommand((String)("/ftb chunks load " + this.chunkPos.field_77276_a + ' ' + this.chunkPos.field_77275_b), (boolean)false);
                } else {
                    FTBLibClient.execClientCommand((String)("/ftb chunks claim " + this.chunkPos.field_77276_a + ' ' + this.chunkPos.field_77275_b), (boolean)false);
                }
            } else if (button.isRight()) {
                if (GuiScreen.func_146272_n()) {
                    FTBLibClient.execClientCommand((String)("/ftb chunks unload " + this.chunkPos.field_77276_a + ' ' + this.chunkPos.field_77275_b), (boolean)false);
                } else {
                    FTBLibClient.execClientCommand((String)("/ftb chunks unclaim " + this.chunkPos.field_77276_a + ' ' + this.chunkPos.field_77275_b), (boolean)false);
                }
            }
            GuiLM.playClickSound();
        }

        public void addMouseOverText(GuiLM gui, List<String> l) {
            ClaimedChunk chunk = FTBUWorldDataSP.getChunk(this.chunkPos);
            if (chunk != null) {
                ForgeTeam team = chunk.owner.getTeam();
                if (team != null) {
                    l.add(team.getColor().textFormatting + team.getTitle());
                    l.add(TextFormatting.GREEN + ClaimedChunk.LANG_CLAIMED.translate());
                    if (team.getStatus((ForgePlayer)ForgeWorldSP.inst.clientPlayer).isAlly()) {
                        l.add(chunk.owner.getProfile().getName());
                        if (chunk.loaded) {
                            l.add(TextFormatting.RED + ClaimedChunk.LANG_LOADED.translate());
                        }
                    }
                }
            } else {
                l.add(TextFormatting.DARK_GREEN + ClaimedChunk.LANG_WILDERNESS.translate());
            }
        }

        public void renderWidget(GuiLM gui) {
            ClaimedChunk chunk = FTBUWorldDataSP.getChunk(this.chunkPos);
            double ax = this.getAX();
            double ay = this.getAY();
            if (chunk != null) {
                FTBLibClient.setTexture((ResourceLocation)TEX_CHUNK_CLAIMING);
                ForgeTeam team = chunk.owner.getTeam();
                if (team != null) {
                    FTBLibClient.setGLColor((int)team.getColor().color, (int)180);
                } else {
                    GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7058824f);
                }
                GuiLM.drawTexturedRect((double)ax, (double)ay, (double)16.0, (double)16.0, (double)GuiClaimChunks.TEX_FILLED.minU, (double)GuiClaimChunks.TEX_FILLED.minV, (double)GuiClaimChunks.TEX_FILLED.maxU, (double)GuiClaimChunks.TEX_FILLED.maxV);
                GlStateManager.func_179131_c((float)(chunk.loaded && team != null && team.getStatus((ForgePlayer)ForgeWorldSP.inst.clientPlayer).isAlly() ? 1.0f : 0.0f), (float)(chunk.isChunkOwner((ForgePlayer)ForgeWorldSP.inst.clientPlayer) ? 0.27f : 0.0f), (float)0.0f, (float)0.78f);
                GuiLM.drawTexturedRect((double)ax, (double)ay, (double)16.0, (double)16.0, (double)GuiClaimChunks.TEX_BORDER.minU, (double)GuiClaimChunks.TEX_BORDER.minV, (double)GuiClaimChunks.TEX_BORDER.maxU, (double)GuiClaimChunks.TEX_BORDER.maxV);
            }
            if (gui.isMouseOver((WidgetLM)this)) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.27f);
                GuiLM.drawBlankRect((double)ax, (double)ay, (double)16.0, (double)16.0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

