/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbu.gui.GuiClaimChunks;
import com.latmod.lib.PixelBuffer;
import com.latmod.lib.math.MathHelperLM;
import com.latmod.lib.util.LMColorUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ThreadReloadArea
extends Thread {
    public static final PixelBuffer pixels = new PixelBuffer(256, 256);
    private static final Map<IBlockState, Integer> colorCache = new HashMap<IBlockState, Integer>();
    private static BlockPos.MutableBlockPos currentBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
    public final World worldObj;
    public final GuiClaimChunks gui;

    public ThreadReloadArea(World w, GuiClaimChunks m) {
        super("LM_MapReloader");
        this.setDaemon(true);
        this.worldObj = w;
        this.gui = m;
    }

    private static int getBlockColor(IBlockState state) {
        Integer col = colorCache.get(state);
        if (col == null) {
            col = 0xFF000000 | ThreadReloadArea.getBlockColor0(state);
            colorCache.put(state, col);
        }
        return col;
    }

    private static int getBlockColor0(IBlockState state) {
        Block b = state.func_177230_c();
        if (b == Blocks.field_150322_A) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150480_ab) {
            return MapColor.field_151645_D.field_76291_p;
        }
        if (b == Blocks.field_150327_N) {
            return MapColor.field_151673_t.field_76291_p;
        }
        if (b == Blocks.field_150353_l) {
            return MapColor.field_151676_q.field_76291_p;
        }
        if (b == Blocks.field_150377_bs) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150343_Z) {
            return 1376327;
        }
        if (b == Blocks.field_150351_n) {
            return 9279387;
        }
        if (b == Blocks.field_150349_c) {
            return 7650428;
        }
        if (b == Blocks.field_150328_O) {
            switch ((BlockFlower.EnumFlowerType)state.func_177229_b(Blocks.field_150328_O.func_176494_l())) {
                case DANDELION: {
                    return MapColor.field_151673_t.field_76291_p;
                }
                case POPPY: {
                    return MapColor.field_151645_D.field_76291_p;
                }
                case BLUE_ORCHID: {
                    return MapColor.field_151674_s.field_76291_p;
                }
                case ALLIUM: {
                    return MapColor.field_151675_r.field_76291_p;
                }
                case HOUSTONIA: {
                    return MapColor.field_151680_x.field_76291_p;
                }
                case RED_TULIP: {
                    return MapColor.field_151645_D.field_76291_p;
                }
                case ORANGE_TULIP: {
                    return MapColor.field_151676_q.field_76291_p;
                }
                case WHITE_TULIP: {
                    return MapColor.field_151666_j.field_76291_p;
                }
                case PINK_TULIP: {
                    return MapColor.field_151671_v.field_76291_p;
                }
                case OXEYE_DAISY: {
                    return MapColor.field_151680_x.field_76291_p;
                }
            }
        } else if (b == Blocks.field_150344_f) {
            switch ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a)) {
                case OAK: {
                    return 13015113;
                }
                case SPRUCE: {
                    return 8150574;
                }
                case BIRCH: {
                    return 15917203;
                }
                case JUNGLE: {
                    return 13006419;
                }
                case ACACIA: {
                    return 14712638;
                }
                case DARK_OAK: {
                    return 5319956;
                }
            }
        }
        return state.func_185909_g().field_76291_p;
    }

    @Override
    public void run() {
        Arrays.fill(ThreadReloadArea.pixels.pixels, 0);
        int startY = Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o();
        try {
            for (int cz = 0; cz < 15; ++cz) {
                for (int cx = 0; cx < 15; ++cx) {
                    Chunk chunk = this.worldObj.func_72863_F().func_186026_b(this.gui.startX + cx, this.gui.startZ + cz);
                    if (chunk != null) {
                        int x = (this.gui.startX + cx) * 16;
                        int z = (this.gui.startZ + cz) * 16;
                        for (int wz = 0; wz < 16; ++wz) {
                            block5: for (int wx = 0; wx < 16; ++wx) {
                                for (int by = Math.max(255, chunk.func_76625_h() + 15); by > 0; --by) {
                                    IBlockState state = chunk.func_186032_a(wx, by, wz);
                                    currentBlockPos.func_181079_c(x + wx, by, z + wz);
                                    if (state.func_177230_c() == Blocks.field_150329_H || this.worldObj.func_175623_d((BlockPos)currentBlockPos)) continue;
                                    int color = ThreadReloadArea.getBlockColor(state);
                                    color = LMColorUtils.addBrightness((int)color, (int)(MathHelperLM.clampInt((int)(by - startY), (int)-30, (int)30) * 5));
                                    pixels.setRGB(cx * 16 + wx, cz * 16 + wz, color);
                                    continue block5;
                                }
                            }
                        }
                    }
                    GuiClaimChunks.pixelBuffer = FTBLibClient.toByteBuffer((int[])ThreadReloadArea.pixels.pixels, (boolean)false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GuiClaimChunks.pixelBuffer = FTBLibClient.toByteBuffer((int[])ThreadReloadArea.pixels.pixels, (boolean)false);
    }
}

