/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui.guide;

import com.feed_the_beast.ftbl.api.info.IResourceProvider;
import com.feed_the_beast.ftbl.api.info.InfoPage;
import com.feed_the_beast.ftbu.gui.guide.GuideType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.latmod.lib.FinalIDObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Guide
extends FinalIDObject {
    public final GuideType type;
    public final String url;
    public final String name;
    public final List<String> authors;
    public final List<String> guide_authors;
    public final Map<String, InfoPage> modes;

    public Guide(GuideType t, String u, JsonObject o) {
        super(o.get("id").getAsString());
        this.type = t;
        this.url = u;
        this.name = o.get("name").getAsString();
        ArrayList<String> l = new ArrayList<String>();
        for (JsonElement e : o.get("authors").getAsJsonArray()) {
            l.add(e.getAsString());
        }
        this.authors = Collections.unmodifiableList(l);
        l = new ArrayList();
        for (JsonElement e : o.get("guide_authors").getAsJsonArray()) {
            l.add(e.getAsString());
        }
        this.guide_authors = Collections.unmodifiableList(l);
        this.modes = new HashMap<String, InfoPage>();
        for (JsonElement e : o.get("modes").getAsJsonArray()) {
            this.modes.put(e.getAsString(), null);
        }
    }

    public abstract boolean isLocal();

    public abstract IResourceProvider getResourceProvider(String var1);

    @SideOnly(value=Side.CLIENT)
    public abstract ResourceLocation getIcon();

    public InfoPage loadPage(String mode) throws Exception {
        InfoPage page = this.modes.get(mode);
        if (mode == null) {
            page = new InfoPage(".");
            this.generatePage(page);
        }
        return page;
    }

    private void generatePage(InfoPage page) {
    }
}

