/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui.guide.local;

import com.feed_the_beast.ftbl.api.info.IResourceProvider;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbu.gui.guide.Guide;
import com.feed_the_beast.ftbu.gui.guide.GuideType;
import com.google.gson.JsonObject;
import com.latmod.lib.io.LMConnection;
import com.latmod.lib.io.RequestMethod;
import java.awt.image.BufferedImage;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LocalGuide
extends Guide {
    public final File folder;
    private ResourceLocation icon;

    public LocalGuide(GuideType t, String u, JsonObject o) {
        super(t, u, o);
        this.folder = new File(FTBLib.folderLocal, "guides/" + this.type.group + "/" + this.getID());
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public IResourceProvider getResourceProvider(String path) {
        return s -> new LMConnection(RequestMethod.FILE, new File(this.folder, path).getAbsolutePath());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIcon() {
        if (this.icon == null) {
            try {
                BufferedImage img = new LMConnection(RequestMethod.FILE, new File(this.folder, "icon.png").getAbsolutePath()).connect().asImage();
                this.icon = Minecraft.func_71410_x().func_110434_K().func_110578_a("ftbu_guide/" + this.getID() + ".png", new DynamicTexture(img));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.icon;
    }
}

