/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.FTBLibStats;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbl.util.LMDimUtils;
import com.feed_the_beast.ftbu.FTBU;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.config.FTBUConfigWorld;
import com.feed_the_beast.ftbu.world.chunks.ChunkloaderType;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataMP;
import com.google.common.collect.MapMaker;
import com.latmod.lib.util.LMUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class FTBUChunkEventHandler
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback {
    public static final FTBUChunkEventHandler instance = new FTBUChunkEventHandler();
    private static final String PLAYER_ID_TAG = "PID";
    private final Map<World, Map<UUID, ForgeChunkManager.Ticket>> table = new MapMaker().weakKeys().makeMap();

    public void init() {
        if (!ForgeChunkManager.getConfig().hasCategory("ftbu")) {
            ForgeChunkManager.getConfig().get("ftbu", "maximumTicketCount", 100).setMinValue(0);
            ForgeChunkManager.getConfig().get("ftbu", "maximumChunksPerTicket", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().save();
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FTBU.inst, (ForgeChunkManager.LoadingCallback)this);
    }

    private ForgeChunkManager.Ticket request(World w, ForgePlayerMP player) {
        ForgeChunkManager.Ticket t;
        if (w == null || player == null) {
            return null;
        }
        UUID playerID = player.getProfile().getId();
        Map<UUID, ForgeChunkManager.Ticket> map = this.table.get(w);
        ForgeChunkManager.Ticket ticket = t = map == null ? null : map.get(playerID);
        if (t == null) {
            t = ForgeChunkManager.requestTicket((Object)FTBU.inst, (World)w, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (t == null) {
                return null;
            }
            t.getModData().func_74778_a(PLAYER_ID_TAG, LMUtils.fromUUID((UUID)playerID));
            if (map == null) {
                map = new HashMap<UUID, ForgeChunkManager.Ticket>();
                this.table.put(w, map);
            }
            map.put(playerID, t);
        }
        return t;
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        this.table.remove(world);
        ArrayList<ForgeChunkManager.Ticket> tickets1 = new ArrayList<ForgeChunkManager.Ticket>();
        if (tickets.isEmpty() || !FTBUConfigWorld.chunk_loading.getAsBoolean()) {
            return tickets1;
        }
        HashMap<UUID, ForgeChunkManager.Ticket> map = new HashMap<UUID, ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket t : tickets) {
            UUID playerID;
            if (t.getModData().func_150299_b(PLAYER_ID_TAG) != 8 || (playerID = LMUtils.fromString((String)t.getModData().func_74779_i(PLAYER_ID_TAG))) == null) continue;
            map.put(playerID, t);
            tickets1.add(t);
        }
        this.table.put(world, map);
        return tickets1;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket t : tickets) {
            Collection<ClaimedChunk> chunks;
            UUID playerID = LMUtils.fromString((String)t.getModData().func_74779_i(PLAYER_ID_TAG));
            if (playerID == null || (chunks = FTBUWorldDataMP.chunks.getChunks(playerID)).isEmpty()) continue;
            int dim = world.field_73011_w.getDimension();
            for (ClaimedChunk c : chunks) {
                if (!c.loaded || c.pos.dim != dim) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)t, (ChunkPos)c.pos);
            }
        }
        this.markDirty(world);
    }

    public void markDirty(World w) {
        if (ForgeWorldMP.inst == null || FTBLib.getServerWorld() == null) {
            return;
        }
        if (w != null) {
            this.markDirty0(w);
        }
        if (!this.table.isEmpty()) {
            World[] worlds;
            for (World w1 : worlds = this.table.keySet().toArray(new World[this.table.size()])) {
                this.markDirty0(w1);
            }
        }
    }

    private void markDirty0(World w) {
        int dim = w.field_73011_w.getDimension();
        for (ClaimedChunk c : FTBUWorldDataMP.chunks.getAllChunks()) {
            ForgeChunkManager.Ticket ticket;
            if (c.pos.dim != dim) continue;
            boolean isLoaded = c.loaded;
            if (isLoaded) {
                ForgePlayerMP p = c.owner.toMP();
                if (p == null) {
                    isLoaded = false;
                } else {
                    double max;
                    ChunkloaderType type = (ChunkloaderType)FTBUPermissions.CHUNKLOADER_TYPE.get(p.getProfile());
                    if (type == ChunkloaderType.DISABLED) {
                        isLoaded = false;
                    } else if (type == ChunkloaderType.ONLINE) {
                        isLoaded = p.isOnline();
                    } else if (type == ChunkloaderType.OFFLINE && !p.isOnline() && (max = FTBUPermissions.CHUNKLOADER_OFFLINE_TIMER.get(p.getProfile())) > 0.0 && FTBLibStats.getLastSeenDeltaInHours((StatisticsManagerServer)p.stats(), (boolean)false) > max) {
                        isLoaded = false;
                        if (c.forced) {
                            FTBU.logger.info("Unloading " + p.getProfile().getName() + " chunks for being offline for too long");
                        }
                    }
                }
            }
            if (c.forced == isLoaded || (ticket = this.request(LMDimUtils.getWorld((int)c.pos.dim), c.owner.toMP())) == null) continue;
            if (isLoaded) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)c.pos);
            } else {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)c.pos);
            }
            c.forced = isLoaded;
        }
    }

    public void clear() {
        this.table.clear();
    }
}

