/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigGroup;
import com.feed_the_beast.ftbl.api.events.ForgePlayerEvent;
import com.feed_the_beast.ftbl.api.item.LMInvUtils;
import com.feed_the_beast.ftbl.api.notification.Notification;
import com.feed_the_beast.ftbl.util.BlockDimPos;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbl.util.EntityDimPos;
import com.feed_the_beast.ftbu.FTBUCapabilities;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.config.FTBUConfigGeneral;
import com.feed_the_beast.ftbu.config.FTBUConfigLogin;
import com.feed_the_beast.ftbu.handlers.FTBUChunkEventHandler;
import com.feed_the_beast.ftbu.net.MessageAreaRequest;
import com.feed_the_beast.ftbu.world.backups.Backups;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.data.FTBUPlayerData;
import com.feed_the_beast.ftbu.world.data.FTBUPlayerDataMP;
import com.feed_the_beast.ftbu.world.data.FTBUPlayerDataSP;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataMP;
import com.google.gson.JsonElement;
import com.latmod.lib.math.MathHelperLM;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FTBUPlayerEventHandler {
    private static Map<UUID, String> lastChunksTeamIDMap = new HashMap<UUID, String>();

    @SubscribeEvent
    public void attachCapabilities(ForgePlayerEvent.AttachCapabilities event) {
        event.addCapability(new ResourceLocation("ftbu", "data"), (ICapabilityProvider)(event.player.getWorld().getSide().isServer() ? new FTBUPlayerDataMP() : new FTBUPlayerDataSP()));
    }

    @SubscribeEvent
    public void onDataSynced(ForgePlayerEvent.Sync event) {
        if (event.player.hasCapability(FTBUCapabilities.FTBU_PLAYER_DATA, null)) {
            FTBUPlayerData data = (FTBUPlayerData)event.player.getCapability(FTBUCapabilities.FTBU_PLAYER_DATA, null);
            if (event.player.getWorld().getSide().isServer()) {
                NBTTagCompound tag = new NBTTagCompound();
                data.writeSyncData(event.player, tag, event.self);
                event.data.func_74782_a("FTBU", (NBTBase)tag);
            } else {
                data.readSyncData(event.player, event.data.func_74775_l("FTBU"), event.self);
            }
        }
    }

    @SubscribeEvent
    public void onLoggedIn(ForgePlayerEvent.LoggedIn event) {
        if (event.player.hasCapability(FTBUCapabilities.FTBU_PLAYER_DATA, null)) {
            if (event.player.getWorld().getSide().isServer()) {
                EntityPlayerMP ep = event.player.toMP().getPlayer();
                if (event.first && FTBUConfigLogin.enable_starting_items.getAsBoolean()) {
                    for (ItemStack is : FTBUConfigLogin.starting_items.getItems()) {
                        LMInvUtils.giveItem((EntityPlayer)ep, (ItemStack)is);
                    }
                }
                if (FTBUConfigLogin.enable_motd.getAsBoolean()) {
                    FTBUConfigLogin.motd.components.forEach(arg_0 -> ((EntityPlayerMP)ep).func_145747_a(arg_0));
                }
                Backups.hadPlayer = true;
                FTBUChunkEventHandler.instance.markDirty(null);
            } else {
                EntityPlayer ep = event.player.getPlayer();
                new MessageAreaRequest(MathHelperLM.chunk((double)ep.field_70165_t) - 3, MathHelperLM.chunk((double)ep.field_70161_v) - 3, 7, 7).sendToServer();
            }
        }
    }

    @SubscribeEvent
    public void onLoggedOut(ForgePlayerEvent.LoggedOut event) {
        if (event.player.hasCapability(FTBUCapabilities.FTBU_PLAYER_DATA, null)) {
            FTBUChunkEventHandler.instance.markDirty(null);
            Backups.hadPlayer = true;
        }
        lastChunksTeamIDMap.remove(event.player.getProfile().getId());
    }

    @SubscribeEvent
    public void getSettings(ForgePlayerEvent.GetSettings event) {
        if (event.player.hasCapability(FTBUCapabilities.FTBU_PLAYER_DATA, null)) {
            FTBUPlayerDataMP data = ((FTBUPlayerData)event.player.getCapability(FTBUCapabilities.FTBU_PLAYER_DATA, null)).toMP();
            ConfigGroup group = new ConfigGroup();
            group.add("render_badge", (ConfigEntry)data.renderBadge);
            group.add("chat_links", (ConfigEntry)data.chatLinks);
            event.settings.add("ftbu", (ConfigEntry)group);
        }
    }

    @SubscribeEvent
    public void addInfo(ForgePlayerEvent.AddInfo event) {
        if (event.player.getWorld().getSide().isServer()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onChunkChanged(EntityEvent.EnteringChunk e) {
        String newTeamID;
        if (e.getEntity().field_70170_p.field_72995_K || !(e.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP ep = (EntityPlayerMP)e.getEntity();
        ForgePlayerMP player = ForgeWorldMP.inst.getPlayer((Object)ep);
        if (player == null || !player.isOnline()) {
            return;
        }
        player.lastPos = new EntityDimPos((Entity)ep).toBlockDimPos();
        ClaimedChunk chunk = FTBUWorldDataMP.chunks.getChunk(new ChunkDimPos(ep.field_71093_bK, e.getNewChunkX(), e.getNewChunkZ()));
        String string = newTeamID = chunk == null || !chunk.owner.hasTeam() ? "" : chunk.owner.getTeamID();
        if (!lastChunksTeamIDMap.containsKey(player.getProfile().getId()) || !lastChunksTeamIDMap.get(player.getProfile().getId()).equals(newTeamID)) {
            lastChunksTeamIDMap.put(player.getProfile().getId(), newTeamID);
            if (!newTeamID.isEmpty()) {
                ForgeTeam team = chunk.owner.getTeam();
                if (team == null) {
                    return;
                }
                TextComponentString msg = new TextComponentString(team.getTitle());
                msg.func_150256_b().func_150227_a(Boolean.valueOf(true));
                Notification n = new Notification("chunk_changed");
                n.addText((ITextComponent)msg);
                if (team.getDesc() != null) {
                    msg = new TextComponentString(team.getDesc());
                    msg.func_150256_b().func_150217_b(Boolean.valueOf(true));
                    n.addText((ITextComponent)msg);
                }
                n.setTimer(3000);
                n.setColor(0xFF000000 | team.getColor().color);
                n.sendTo(ep);
            } else {
                ITextComponent msg = ClaimedChunk.LANG_WILDERNESS.textComponent(new Object[0]);
                msg.func_150256_b().func_150227_a(Boolean.valueOf(true));
                Notification n = new Notification("chunk_changed");
                n.addText(msg);
                n.setTimer(3000);
                n.setColor(-16736240);
                n.setItem(new ItemStack(Blocks.field_150395_bd));
                n.sendTo(ep);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent e) {
        if (e.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (e.getEntity().field_71093_bK != 0 || !(e.getEntity() instanceof EntityPlayerMP) || e.getEntity() instanceof FakePlayer) {
            return;
        }
        Entity entity = e.getSource().func_76364_f();
        if (entity != null && (entity instanceof EntityPlayerMP || entity instanceof IMob)) {
            if (entity instanceof FakePlayer) {
                return;
            }
            if (FTBUConfigGeneral.safe_spawn.getAsBoolean() && FTBUWorldDataMP.isInSpawnD(e.getEntity().field_71093_bK, e.getEntity().field_70165_t, e.getEntity().field_70161_v)) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ClaimedChunk chunk;
        ForgePlayerMP player;
        if (event.getEntityPlayer() instanceof EntityPlayerMP && (player = ForgeWorldMP.inst.getPlayer((Object)event.getEntityPlayer())) != null && (chunk = FTBUWorldDataMP.chunks.getChunk(new BlockDimPos((Vec3i)event.getPos(), player.getPlayer().field_71093_bK).toChunkPos())) != null && !chunk.canInteract(player, false, event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ForgePlayerMP player;
        if (event.getPlayer() instanceof EntityPlayerMP && (player = ForgeWorldMP.inst.getPlayer((Object)event.getPlayer())) != null) {
            for (JsonElement e : FTBUPermissions.CLAIMS_BREAK_WHITELIST.getJson(player.getProfile()).getAsJsonArray()) {
                if (!e.getAsString().equals(LMInvUtils.getRegName((Block)player.getPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c()).toString())) continue;
                return;
            }
            ClaimedChunk chunk = FTBUWorldDataMP.chunks.getChunk(new BlockDimPos((Vec3i)event.getPos(), player.getPlayer().field_71093_bK).toChunkPos());
            if (chunk != null && !chunk.canInteract(player, true, event.getPos())) {
                event.setCanceled(true);
            }
        }
    }
}

