/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.ServerTickCallback;
import com.feed_the_beast.ftbl.api.events.RegisterFTBCommandsEvent;
import com.feed_the_beast.ftbl.api.events.ReloadEvent;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbu.FTBU;
import com.feed_the_beast.ftbu.cmd.CmdAdminHome;
import com.feed_the_beast.ftbu.cmd.CmdBack;
import com.feed_the_beast.ftbu.cmd.CmdBackup;
import com.feed_the_beast.ftbu.cmd.CmdChunks;
import com.feed_the_beast.ftbu.cmd.CmdDelHome;
import com.feed_the_beast.ftbu.cmd.CmdDelWarp;
import com.feed_the_beast.ftbu.cmd.CmdGetRank;
import com.feed_the_beast.ftbu.cmd.CmdHome;
import com.feed_the_beast.ftbu.cmd.CmdInv;
import com.feed_the_beast.ftbu.cmd.CmdRestart;
import com.feed_the_beast.ftbu.cmd.CmdServerInfo;
import com.feed_the_beast.ftbu.cmd.CmdSetHome;
import com.feed_the_beast.ftbu.cmd.CmdSetRank;
import com.feed_the_beast.ftbu.cmd.CmdSetWarp;
import com.feed_the_beast.ftbu.cmd.CmdSpawn;
import com.feed_the_beast.ftbu.cmd.CmdTplast;
import com.feed_the_beast.ftbu.cmd.CmdTrashCan;
import com.feed_the_beast.ftbu.cmd.CmdWarp;
import com.feed_the_beast.ftbu.handlers.FTBUChunkEventHandler;
import com.feed_the_beast.ftbu.ranks.Ranks;
import com.feed_the_beast.ftbu.world.ServerInfoFile;
import com.feed_the_beast.ftbu.world.data.FTBUPlayerData;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataMP;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FTBUServerEventHandler {
    private static final String[] LINK_PREFIXES = new String[]{"http://", "https://"};

    private static int getFirstLinkIndex(String s) {
        for (String s1 : LINK_PREFIXES) {
            int idx = s.indexOf(s1);
            if (idx == -1) continue;
            return idx;
        }
        return -1;
    }

    @SubscribeEvent
    public void onReloaded(ReloadEvent e) {
        if (e.world.getSide().isServer()) {
            ServerInfoFile.CachedInfo.reload();
            Ranks.instance().reload();
            FTBUWorldDataMP.reloadServerBadges();
            if (FTBLib.getServerWorld() != null) {
                FTBUChunkEventHandler.instance.markDirty(null);
            }
        } else {
            FTBU.proxy.onReloadedClient();
        }
    }

    @SubscribeEvent
    public void registerAdminCmds(RegisterFTBCommandsEvent event) {
        if (event.isDedi) {
            event.add((ICommand)new CmdRestart());
        }
        event.add((ICommand)new CmdInv());
        event.add((ICommand)new CmdSetWarp());
        event.add((ICommand)new CmdDelWarp());
        event.add((ICommand)new CmdBackup());
        event.add((ICommand)new CmdAdminHome());
        event.add((ICommand)new CmdServerInfo());
        event.add((ICommand)new CmdTplast());
        event.add((ICommand)new CmdTrashCan());
        event.add((ICommand)new CmdBack());
        event.add((ICommand)new CmdSpawn());
        event.add((ICommand)new CmdWarp());
        event.add((ICommand)new CmdHome());
        event.add((ICommand)new CmdSetHome());
        event.add((ICommand)new CmdDelHome());
        event.add((ICommand)new CmdGetRank());
        event.add((ICommand)new CmdSetRank());
        event.add((ICommand)new CmdChunks());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatEvent(ServerChatEvent e) {
        String[] msg = FTBLib.removeFormatting((String)e.getMessage()).split(" ");
        ArrayList<String> links = new ArrayList<String>();
        for (String s : msg) {
            int index = FTBUServerEventHandler.getFirstLinkIndex(s);
            if (index == -1) continue;
            links.add(s.substring(index).trim());
        }
        if (!links.isEmpty()) {
            TextComponentString line = new TextComponentString("");
            boolean oneLink = links.size() == 1;
            for (int i = 0; i < links.size(); ++i) {
                String link = (String)links.get(i);
                TextComponentString c = new TextComponentString(oneLink ? "[ Link ]" : "[ Link #" + (i + 1) + " ]");
                c.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(link)));
                c.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
                line.func_150257_a((ITextComponent)c);
                if (oneLink) continue;
                line.func_150257_a((ITextComponent)new TextComponentString(" "));
            }
            line.func_150256_b().func_150238_a(TextFormatting.GOLD);
            FTBLib.addCallback((ServerTickCallback)new ServerTickCallback((ITextComponent)line){
                final /* synthetic */ ITextComponent val$line;
                {
                    this.val$line = iTextComponent;
                }

                public void onCallback() {
                    for (ForgePlayer p : ForgeWorldMP.inst.getOnlinePlayers()) {
                        if (!FTBUPlayerData.get((ForgePlayer)p).toMP().chatLinks.getAsBoolean()) continue;
                        p.getPlayer().func_145747_a(this.val$line);
                    }
                }
            });
        }
    }
}

