/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.api.events.ForgeWorldEvent;
import com.feed_the_beast.ftbu.FTBUCapabilities;
import com.feed_the_beast.ftbu.badges.Badge;
import com.feed_the_beast.ftbu.config.FTBUConfigGeneral;
import com.feed_the_beast.ftbu.world.data.FTBUWorldData;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataMP;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FTBUWorldEventHandler {
    @SubscribeEvent
    public void attachCapabilities(ForgeWorldEvent.AttachCapabilities event) {
        ResourceLocation r = new ResourceLocation("ftbu", "data");
        event.addCapability(r, (ICapabilityProvider)(event.world.getSide().isServer() ? new FTBUWorldDataMP() : new FTBUWorldDataSP()));
    }

    @SubscribeEvent
    public void onWorldLoaded(ForgeWorldEvent.Loaded event) {
        if (event.world.hasCapability(FTBUCapabilities.FTBU_WORLD_DATA, null)) {
            ((FTBUWorldData)event.world.getCapability(FTBUCapabilities.FTBU_WORLD_DATA, null)).onLoaded();
        }
    }

    @SubscribeEvent
    public void onWorldLoadedBeforePlayers(ForgeWorldEvent.LoadedBeforePlayers event) {
        if (event.world.hasCapability(FTBUCapabilities.FTBU_WORLD_DATA, null)) {
            ((FTBUWorldData)event.world.getCapability(FTBUCapabilities.FTBU_WORLD_DATA, null)).onLoadedBeforePlayers();
        }
    }

    @SubscribeEvent
    public void onWorldClosed(ForgeWorldEvent.Closed event) {
        if (event.world.hasCapability(FTBUCapabilities.FTBU_WORLD_DATA, null)) {
            ((FTBUWorldData)event.world.getCapability(FTBUCapabilities.FTBU_WORLD_DATA, null)).onClosed();
        }
    }

    @SubscribeEvent
    public void onDataSynced(ForgeWorldEvent.Sync event) {
        if (event.world.getSide().isServer()) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound tag1 = new NBTTagCompound();
            for (Badge b : FTBUWorldDataMP.localBadges.badgeMap.values()) {
                tag1.func_74778_a(b.getID(), b.imageURL);
            }
            tag.func_74782_a("B", (NBTBase)tag1);
            event.syncData.func_74782_a("FTBU", (NBTBase)tag);
        } else {
            NBTTagCompound tag = event.syncData.func_74775_l("FTBU");
            NBTTagCompound tag1 = tag.func_74775_l("B");
            FTBUWorldDataSP.localBadges.clear();
            FTBUWorldDataSP.localBadges.copyFrom(FTBUWorldDataSP.globalBadges);
            for (String key : tag1.func_150296_c()) {
                FTBUWorldDataSP.localBadges.badgeMap.put(key, new Badge(key, tag1.func_74779_i(key)));
            }
        }
    }

    @SubscribeEvent
    public void onMobSpawned(EntityJoinWorldEvent e) {
        if (!e.getWorld().field_72995_K && !this.isEntityAllowed(e.getEntity())) {
            e.getEntity().func_70106_y();
            e.setCanceled(true);
        }
    }

    private boolean isEntityAllowed(Entity e) {
        if (e instanceof EntityPlayer) {
            return true;
        }
        if (FTBUConfigGeneral.blocked_entities.isEntityBanned(e.getClass())) {
            return false;
        }
        if (FTBUConfigGeneral.safe_spawn.getAsBoolean() && FTBUWorldDataMP.isInSpawnD(e.field_71093_bK, e.field_70165_t, e.field_70161_v)) {
            if (e instanceof IMob) {
                return false;
            }
            if (e instanceof EntityChicken && !e.func_184188_bt().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start e) {
        if (!e.getWorld().field_72995_K && !FTBUWorldDataMP.allowExplosion(e.getWorld(), e.getExplosion())) {
            e.setCanceled(true);
        }
    }
}

