/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.journeymap;

import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbu.journeymap.IJMPluginHandler;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.data.FTBUWorldData;
import java.util.HashMap;
import java.util.Map;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.util.text.TextFormatting;

public class JMPluginHandler
implements IJMPluginHandler {
    private final IClientAPI clientAPI;
    private final Map<ChunkDimPos, PolygonOverlay> polygons;

    public JMPluginHandler(IClientAPI api) {
        this.clientAPI = api;
        this.polygons = new HashMap<ChunkDimPos, PolygonOverlay>();
    }

    @Override
    public void mappingStarted() {
    }

    @Override
    public void mappingStopped() {
        this.polygons.clear();
        this.clientAPI.removeAll("ftbu");
    }

    @Override
    public void chunkChanged(ChunkDimPos pos, ClaimedChunk chunk) {
        try {
            if (FTBUWorldData.isLoadedW((ForgeWorld)ForgeWorldSP.inst) && this.clientAPI.playerAccepts("ftbu", DisplayType.Polygon)) {
                if (chunk != null) {
                    ForgeTeam team = chunk.owner.getTeam();
                    MapPolygon poly = PolygonHelper.createChunkPolygon((int)pos.field_77276_a, (int)100, (int)pos.field_77275_b);
                    ShapeProperties shapeProperties = new ShapeProperties();
                    shapeProperties.setFillOpacity(0.3f);
                    shapeProperties.setStrokeOpacity(0.2f);
                    StringBuilder sb = new StringBuilder();
                    if (team != null) {
                        shapeProperties.setFillColor(team.getColor().color);
                        sb.append(team.getColor().textFormatting);
                        sb.append(team.getTitle());
                        sb.append('\n');
                        sb.append(TextFormatting.GREEN);
                        sb.append(ClaimedChunk.LANG_CLAIMED.translate());
                    } else {
                        shapeProperties.setFillColor(0);
                    }
                    shapeProperties.setStrokeColor(0);
                    PolygonOverlay chunkOverlay = new PolygonOverlay("ftbu", "claimed_" + pos.dim + '_' + pos.field_77276_a + '_' + pos.field_77275_b, pos.dim, shapeProperties, poly);
                    chunkOverlay.setOverlayGroupName("Claimed Chunks").setTitle(sb.toString());
                    this.polygons.put(pos, chunkOverlay);
                    this.clientAPI.show((Displayable)chunkOverlay);
                } else {
                    PolygonOverlay p = this.polygons.get(pos);
                    if (p != null) {
                        this.clientAPI.remove((Displayable)p);
                        this.polygons.remove(pos);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

