/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerSP;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.api.net.MessageToClient;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataMP;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataSP;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class MessageAreaUpdate
extends MessageToClient<MessageAreaUpdate> {
    public int dim;
    public Map<ChunkDimPos, ClaimedChunk> types;

    public MessageAreaUpdate() {
    }

    public MessageAreaUpdate(int x, int z, int d, int sx, int sz) {
        this.dim = d;
        this.types = new HashMap<ChunkDimPos, ClaimedChunk>();
        for (int x1 = x; x1 < x + sx; ++x1) {
            for (int z1 = z; z1 < z + sz; ++z1) {
                ChunkDimPos pos = new ChunkDimPos(d, x1, z1);
                this.types.put(pos, FTBUWorldDataMP.chunks.getChunk(pos));
            }
        }
    }

    public LMNetworkWrapper getWrapper() {
        return FTBUNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        this.dim = io.readInt();
        this.types = new HashMap<ChunkDimPos, ClaimedChunk>();
        int s = io.readInt();
        for (int i = 0; i < s; ++i) {
            int x = io.readInt();
            int z = io.readInt();
            ChunkDimPos pos = new ChunkDimPos(this.dim, x, z);
            boolean b = io.readBoolean();
            if (b) {
                ForgePlayerSP owner;
                ForgePlayerSP forgePlayerSP = owner = ForgeWorldSP.inst == null ? null : ForgeWorldSP.inst.getPlayer((Object)MessageAreaUpdate.readUUID((ByteBuf)io));
                if (owner == null) continue;
                ClaimedChunk chunk = new ClaimedChunk((ForgeWorld)ForgeWorldSP.inst, (ForgePlayer)owner, pos);
                chunk.loaded = io.readBoolean();
                this.types.put(pos, chunk);
                continue;
            }
            this.types.put(pos, null);
        }
    }

    public void toBytes(ByteBuf io) {
        io.writeInt(this.dim);
        io.writeInt(this.types.size());
        for (Map.Entry<ChunkDimPos, ClaimedChunk> e : this.types.entrySet()) {
            io.writeInt(e.getKey().field_77276_a);
            io.writeInt(e.getKey().field_77275_b);
            if (e.getValue() == null) {
                io.writeBoolean(false);
                continue;
            }
            io.writeBoolean(true);
            MessageAreaUpdate.writeUUID((ByteBuf)io, (UUID)e.getValue().owner.getProfile().getId());
            io.writeBoolean(e.getValue().loaded);
        }
    }

    public void onMessage(MessageAreaUpdate m, Minecraft mc) {
        if (ForgeWorldSP.inst != null) {
            FTBUWorldDataSP.setTypes(m.types);
        }
    }
}

