/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.ranks;

import com.feed_the_beast.ftbl.api.permissions.rankconfig.RankConfig;
import com.feed_the_beast.ftbl.api.permissions.rankconfig.RankConfigAPI;
import com.feed_the_beast.ftbu.ranks.Ranks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.FinalIDObject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class Rank
extends FinalIDObject
implements IJsonSerializable {
    public final Map<String, Boolean> permissions;
    public final Map<RankConfig, JsonElement> config;
    public Rank parent = null;
    public TextFormatting color = TextFormatting.WHITE;
    public String prefix = "";
    public String badge = "";

    public Rank(String id) {
        super(id);
        this.permissions = new LinkedHashMap<String, Boolean>();
        this.config = new LinkedHashMap<RankConfig, JsonElement>();
    }

    public Event.Result handlePermission(String permission) {
        if (this.permissions.containsKey("*")) {
            return this.permissions.get("*") != false ? Event.Result.ALLOW : Event.Result.DENY;
        }
        if (this.permissions.containsKey(permission)) {
            return this.permissions.get(permission) != false ? Event.Result.ALLOW : Event.Result.DENY;
        }
        return Event.Result.DEFAULT;
    }

    public JsonElement handleRankConfig(RankConfig permission) {
        if (this == Ranks.PLAYER) {
            return permission.getDefaultValue(false);
        }
        if (this == Ranks.ADMIN) {
            return permission.getDefaultValue(true);
        }
        JsonElement e = this.config.get(permission);
        return e == null ? (this.parent != null ? this.parent.handleRankConfig(permission) : null) : e;
    }

    @Nonnull
    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        o.add("parent", (JsonElement)new JsonPrimitive(this.parent == null ? "" : this.parent.getID()));
        o.add("color", (JsonElement)new JsonPrimitive(this.color.func_96297_d()));
        o.add("prefix", (JsonElement)new JsonPrimitive(this.prefix));
        o.add("badge", (JsonElement)new JsonPrimitive(this.badge));
        if (!this.permissions.isEmpty()) {
            JsonArray a1 = new JsonArray();
            for (Map.Entry<String, Boolean> entry : this.permissions.entrySet()) {
                a1.add((JsonElement)new JsonPrimitive((entry.getValue() != false ? "+" : "-") + entry.getKey()));
            }
            o.add("permissions", (JsonElement)a1);
        }
        if (!this.config.isEmpty()) {
            JsonObject o1 = new JsonObject();
            for (Map.Entry<String, Boolean> entry : this.config.entrySet()) {
                o1.add(((RankConfig)entry.getKey()).getID(), (JsonElement)entry.getValue());
            }
            o.add("config", (JsonElement)o1);
        }
        return o;
    }

    public void func_152753_a(@Nonnull JsonElement e) {
        JsonObject o = e.getAsJsonObject();
        this.parent = o.has("parent") ? Ranks.instance().ranks.get(o.get("parent").getAsString()) : null;
        this.color = o.has("color") ? TextFormatting.func_96300_b((String)o.get("color").getAsString()) : TextFormatting.WHITE;
        this.prefix = o.has("prefix") ? o.get("prefix").getAsString() : "";
        this.badge = o.has("badge") ? o.get("badge").getAsString() : "";
        this.permissions.clear();
        this.config.clear();
        if (o.has("permissions")) {
            JsonArray a = o.get("permissions").getAsJsonArray();
            for (int i = 0; i < a.size(); ++i) {
                String id = a.get(i).getAsString();
                char firstChar = id.charAt(0);
                boolean b = firstChar == '-';
                this.permissions.put(firstChar == '-' || firstChar == '+' ? id.substring(1) : id, b);
            }
        }
        if (o.has("config")) {
            for (Map.Entry entry : o.get("config").getAsJsonObject().entrySet()) {
                RankConfig c = RankConfigAPI.getRankConfig((String)((String)entry.getKey()));
                if (c == null || ((JsonElement)entry.getValue()).isJsonNull()) continue;
                this.config.put(c, (JsonElement)entry.getValue());
            }
        }
    }

    public boolean allowCommand(MinecraftServer server, ICommandSender sender, ICommand command) {
        Event.Result b = this.handlePermission("command." + command.func_71517_b());
        if (b != Event.Result.DEFAULT) {
            return b == Event.Result.ALLOW;
        }
        if (this.parent == null) {
            return command.func_184882_a(server, sender);
        }
        return this.parent.allowCommand(server, sender, command);
    }
}

