/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.ranks;

import com.feed_the_beast.ftbl.api.permissions.Context;
import com.feed_the_beast.ftbl.api.permissions.PermissionHandler;
import com.feed_the_beast.ftbl.api.permissions.rankconfig.RankConfig;
import com.feed_the_beast.ftbl.api.permissions.rankconfig.RankConfigAPI;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbu.ranks.Rank;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.json.LMJsonUtils;
import com.latmod.lib.util.LMFileUtils;
import com.latmod.lib.util.LMUtils;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Ranks
implements PermissionHandler,
RankConfigAPI.Handler {
    public static final Rank PLAYER = new Rank("Player");
    public static final Rank ADMIN = new Rank("Admin");
    private static Ranks instance;
    public final File fileRanks;
    public final File filePlayers;
    public final Map<String, Rank> ranks = new LinkedHashMap<String, Rank>();
    public final Map<UUID, Rank> playerMap = new HashMap<UUID, Rank>();
    public Rank defaultRank;

    private Ranks() {
        this.fileRanks = new File(FTBLib.folderLocal, "ftbu/ranks.json");
        this.filePlayers = new File(FTBLib.folderLocal, "ftbu/player_ranks.json");
        Ranks.ADMIN.color = TextFormatting.DARK_GREEN;
        Ranks.PLAYER.color = TextFormatting.WHITE;
        Ranks.ADMIN.parent = PLAYER;
    }

    public static Ranks instance() {
        if (instance == null) {
            instance = new Ranks();
        }
        return instance;
    }

    public void reload() {
        Object o;
        JsonElement e;
        this.ranks.clear();
        this.playerMap.clear();
        this.defaultRank = null;
        try {
            e = LMJsonUtils.fromJson((File)this.fileRanks);
            if (e.isJsonObject()) {
                o = e.getAsJsonObject();
                for (Map.Entry entry : o.get("ranks").getAsJsonObject().entrySet()) {
                    this.ranks.put((String)entry.getKey(), new Rank((String)entry.getKey()));
                }
                for (Map.Entry entry : o.get("ranks").getAsJsonObject().entrySet()) {
                    this.ranks.get(entry.getKey()).func_152753_a((JsonElement)((JsonElement)entry.getValue()).getAsJsonObject());
                }
                this.defaultRank = this.ranks.get(o.get("default_rank").getAsString());
            } else {
                o = new JsonObject();
                o.add("default_rank", (JsonElement)new JsonPrimitive(PLAYER.getID()));
                JsonObject o1 = new JsonObject();
                o1.add(PLAYER.getID(), PLAYER.func_151003_a());
                o1.add(ADMIN.getID(), ADMIN.func_151003_a());
                o.add("ranks", (JsonElement)o1);
                LMJsonUtils.toJson((File)this.fileRanks, (JsonElement)o);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.defaultRank = null;
        }
        try {
            e = LMJsonUtils.fromJson((File)LMFileUtils.newFile((File)this.filePlayers));
            if (e.isJsonObject()) {
                for (Map.Entry entry : e.getAsJsonObject().entrySet()) {
                    String s;
                    UUID id = LMUtils.fromString((String)((String)entry.getKey()));
                    if (id == null || !this.ranks.containsKey(s = ((JsonElement)entry.getValue()).getAsString())) continue;
                    this.playerMap.put(id, this.ranks.get(s));
                }
            } else {
                o = new JsonObject();
                o.add(new UUID(0L, 0L).toString(), (JsonElement)new JsonPrimitive("ExampleRank"));
                LMJsonUtils.toJson((File)this.filePlayers, (JsonElement)o);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.defaultRank = null;
        }
        this.saveRanks();
    }

    public void saveRanks() {
        if (this.defaultRank != null) {
            JsonObject o = new JsonObject();
            o.add("default_rank", (JsonElement)new JsonPrimitive(this.defaultRank.getID()));
            JsonObject o1 = new JsonObject();
            for (Rank rank : this.ranks.values()) {
                o1.add(rank.getID(), rank.func_151003_a());
            }
            o.add("ranks", (JsonElement)o1);
            LMJsonUtils.toJson((File)this.fileRanks, (JsonElement)o);
            o = new JsonObject();
            for (Map.Entry entry : this.playerMap.entrySet()) {
                o.add(LMUtils.fromUUID((UUID)((UUID)entry.getKey())), (JsonElement)new JsonPrimitive(((Rank)((Object)entry.getValue())).getID()));
            }
            LMJsonUtils.toJson((File)this.filePlayers, (JsonElement)o);
        }
    }

    public void generateExampleFiles() {
        ArrayList sortedRankConfigs = new ArrayList();
        sortedRankConfigs.addAll(RankConfigAPI.getRankConfigValues());
        Collections.sort(sortedRankConfigs, LMUtils.ID_COMPARATOR);
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add("Modifying this file won't do anything, it just shows all available permission IDs. See ranks_example.json");
            list.add("");
            list.add("-- Permissions --");
            list.add("");
            list.add("-- Config --");
            list.add("");
            for (RankConfig p : sortedRankConfigs) {
                list.add(p.getID());
                list.add("");
            }
            LMFileUtils.save((File)new File(FTBLib.folderLocal, "ftbu/all_permissions.txt"), list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            JsonObject o = new JsonObject();
            o.add("default_rank", (JsonElement)new JsonPrimitive("Player"));
            JsonObject o1 = new JsonObject();
            Rank rankPlayer = new Rank(PLAYER.getID());
            rankPlayer.func_152753_a(PLAYER.func_151003_a());
            for (RankConfig p : sortedRankConfigs) {
                rankPlayer.config.put(p, p.getDefaultValue(false));
            }
            rankPlayer.permissions.clear();
            o1.add(rankPlayer.getID(), rankPlayer.func_151003_a());
            Rank rankAdmin = new Rank(ADMIN.getID());
            rankAdmin.parent = rankPlayer;
            rankAdmin.func_152753_a(ADMIN.func_151003_a());
            for (RankConfig p : sortedRankConfigs) {
                if (p.getDefaultValue(false).toString().equals(p.getDefaultValue(true).toString())) continue;
                rankAdmin.config.put(p, p.getDefaultValue(true));
            }
            rankAdmin.permissions.put("*", true);
            o1.add(rankAdmin.getID(), rankAdmin.func_151003_a());
            o.add("ranks", (JsonElement)o1);
            LMJsonUtils.toJson((File)new File(FTBLib.folderLocal, "ftbu/ranks_example.json"), (JsonElement)o);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Rank getRank(String s) {
        return this.ranks.get(s);
    }

    public Rank getRankOf(GameProfile profile) {
        if (this.defaultRank != null) {
            Rank r = this.playerMap.get(profile.getId());
            return r == null ? this.defaultRank : r;
        }
        return FTBLib.isOP((GameProfile)profile) ? ADMIN : PLAYER;
    }

    public void setRank(UUID player, Rank rank) {
        if (this.defaultRank != null) {
            this.playerMap.put(player, rank);
        }
    }

    @Nonnull
    public Event.Result hasPermission(@Nonnull GameProfile profile, @Nonnull String permission, @Nonnull Context context) {
        return this.getRankOf(profile).handlePermission(permission);
    }

    public JsonElement getRankConfig(@Nonnull GameProfile profile, @Nonnull RankConfig config) {
        return this.getRankOf(profile).handleRankConfig(config);
    }
}

