/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.webapi;

import com.feed_the_beast.ftbu.config.FTBUConfigWebAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonTable {
    private final Map<String, String> ids = new LinkedHashMap<String, String>();
    private final List<TableEntry> entries = new ArrayList<TableEntry>();

    public void setTitle(String id, String translated) {
        if (translated != null && !translated.isEmpty()) {
            this.ids.put(id, translated);
        }
    }

    public void addEntry(TableEntry e) {
        if (e != null) {
            this.entries.add(e);
        }
    }

    public JsonObject toJson() {
        JsonObject o = new JsonObject();
        String[] ids1 = this.ids.keySet().toArray(new String[this.ids.size()]);
        o.add("columns", (JsonElement)new JsonPrimitive((Number)ids1.length));
        o.add("rows", (JsonElement)new JsonPrimitive((Number)this.entries.size()));
        JsonArray a = new JsonArray();
        if (FTBUConfigWebAPI.output_map.getAsBoolean()) {
            JsonObject o1 = new JsonObject();
            for (String s : ids1) {
                o1.add(s, (JsonElement)new JsonPrimitive(this.ids.get(s)));
            }
            o.add("ids", (JsonElement)o1);
            for (TableEntry entry : this.entries) {
                o1 = new JsonObject();
                for (String s : ids1) {
                    o1.add(s, entry.get(s));
                }
                a.add((JsonElement)o1);
            }
            o.add("table", (JsonElement)a);
        } else {
            for (String s : ids1) {
                a.add((JsonElement)new JsonPrimitive(s));
            }
            o.add("ids", (JsonElement)a);
            a = new JsonArray();
            for (String s : ids1) {
                a.add((JsonElement)new JsonPrimitive(this.ids.get(s)));
            }
            o.add("ids_loc", (JsonElement)a);
            a = new JsonArray();
            for (TableEntry entry : this.entries) {
                JsonArray a1 = new JsonArray();
                for (String s : ids1) {
                    a1.add(entry.get(s));
                }
                a.add((JsonElement)a1);
            }
            o.add("table", (JsonElement)a);
        }
        return o;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static final class CellID {
        public final String x;
        public final String y;

        public CellID(String px, String py) {
            this.x = px;
            this.y = py;
        }

        public String toString() {
            return this.x + ':' + this.y;
        }

        public boolean equals(Object o) {
            if (o instanceof CellID) {
                CellID id = (CellID)o;
                return id.x.equals(this.x) && id.y.equals(this.y);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.x.hashCode() + this.y.hashCode();
        }
    }

    public static class TableEntry {
        private final Map<String, JsonElement> values = new HashMap<String, JsonElement>();

        public TableEntry set(String s, JsonElement e) {
            this.values.put(s, e);
            return this;
        }

        public JsonElement get(String s) {
            JsonElement e = this.values.get(s);
            return s == null ? JsonNull.INSTANCE : e;
        }
    }
}

