/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.webapi;

import com.feed_the_beast.ftbl.FTBLibStats;
import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbu.config.FTBUConfigWebAPI;
import com.feed_the_beast.ftbu.webapi.JsonTable;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.json.LMJsonUtils;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;

public class WebAPI
extends Thread {
    public static final WebAPI INST = new WebAPI();
    private ServerSocket serverSocket;

    private WebAPI() {
        super("FTBU_WebAPI");
    }

    public static String readArgs(InputStream is) throws Exception {
        if (is != null) {
            int a = is.available();
            if (a <= 0) {
                return Integer.toString(a);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < a; ++i) {
                sb.append((char)is.read());
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(FTBUConfigWebAPI.port.getAsInt());
            System.out.println(this.getName() + " started");
            while (this.isAPIRunning()) {
                try {
                    Socket socket = this.serverSocket.accept();
                    PrintWriter out = new PrintWriter(socket.getOutputStream());
                    out.println("HTTP/1.0 200 OK");
                    out.println("Content-Type: application/json");
                    out.println("Server: Bot");
                    out.println("");
                    JsonTable table = new JsonTable();
                    table.setTitle("name", "Name");
                    table.setTitle("deaths", "Deaths");
                    table.setTitle("dph", "Deaths per hour");
                    table.setTitle("last_seen", "Last time seen");
                    for (ForgePlayer player : ForgeWorldMP.inst.playerMap.values()) {
                        StatisticsManagerServer stats = player.toMP().stats();
                        JsonTable.TableEntry tableEntry = new JsonTable.TableEntry();
                        tableEntry.set("name", (JsonElement)new JsonPrimitive(player.getProfile().getName()));
                        tableEntry.set("deaths", (JsonElement)new JsonPrimitive((Number)stats.func_77444_a(StatList.field_188069_A)));
                        tableEntry.set("dph", (JsonElement)new JsonPrimitive((Number)FTBLibStats.getDeathsPerHour((StatisticsManagerServer)stats)));
                        tableEntry.set("last_seen", (JsonElement)new JsonPrimitive((Number)(player.toMP().isOnline() ? 0L : FTBLibStats.getLastSeen((StatisticsManagerServer)stats, (boolean)false))));
                        table.addEntry(tableEntry);
                    }
                    JsonObject json = new JsonObject();
                    json.add("time", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                    json.add("stats", (JsonElement)table.toJson());
                    String outputData = LMJsonUtils.toJson((Gson)LMJsonUtils.GSON, (JsonElement)json);
                    out.print(outputData);
                    out.flush();
                    socket.close();
                    System.out.println("Sent data: " + outputData);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println(this.getName() + " closed");
        }
        catch (Exception ex0) {
            ex0.printStackTrace();
        }
    }

    public boolean isAPIRunning() {
        return FTBUConfigWebAPI.enabled.getAsBoolean() && ForgeWorldMP.inst != null && this.serverSocket != null && !this.serverSocket.isClosed();
    }

    public void startAPI() {
        if (FTBUConfigWebAPI.enabled.getAsBoolean() && !this.isAPIRunning()) {
            this.start();
        }
    }

    public void stopAPI() {
        if (this.isAPIRunning()) {
            try {
                this.serverSocket.close();
            }
            catch (Exception ex) {
                this.serverSocket = null;
            }
        }
    }
}

