/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world;

import com.feed_the_beast.ftbl.FTBLibLang;
import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.cmd.ICustomCommandInfo;
import com.feed_the_beast.ftbl.api.info.InfoExtendedTextLine;
import com.feed_the_beast.ftbl.api.info.InfoPage;
import com.feed_the_beast.ftbl.api.notification.ClickAction;
import com.feed_the_beast.ftbl.api.notification.ClickActionType;
import com.feed_the_beast.ftbl.api.permissions.Context;
import com.feed_the_beast.ftbl.api.permissions.PermissionAPI;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbu.FTBULang;
import com.feed_the_beast.ftbu.FTBUTops;
import com.feed_the_beast.ftbu.api.EventFTBUServerInfo;
import com.feed_the_beast.ftbu.api.TopRegistry;
import com.feed_the_beast.ftbu.client.FTBUActions;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.config.FTBUConfigGeneral;
import com.feed_the_beast.ftbu.config.FTBUConfigWorld;
import com.feed_the_beast.ftbu.world.backups.Backups;
import com.feed_the_beast.ftbu.world.data.FTBUPlayerData;
import com.feed_the_beast.ftbu.world.data.FTBUWorldData;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.util.LMStringUtils;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ServerInfoFile
extends InfoPage {
    public ServerInfoFile(@Nonnull ForgePlayerMP self) {
        super(CachedInfo.main.getID());
        this.setTitle(CachedInfo.main.getTitleComponent());
        MinecraftServer server = FTBLib.getServer();
        boolean isDedi = server.func_71262_S();
        boolean isOP = !isDedi || PermissionAPI.hasPermission((GameProfile)self.getProfile(), (String)"ftbu.display.admin_info", (boolean)false, (Context)new Context((Entity)self.getPlayer()));
        this.copyFrom(CachedInfo.main);
        ArrayList<ForgePlayerMP> players = new ArrayList<ForgePlayerMP>(ForgeWorldMP.inst.playerMap.size());
        for (Object p : ForgeWorldMP.inst.playerMap.values()) {
            players.add(p.toMP());
        }
        if (FTBUConfigWorld.auto_restart.getAsBoolean()) {
            this.println(FTBULang.timer_restart.textComponent(new Object[]{LMStringUtils.getTimeString((long)(FTBUWorldData.getW((ForgeWorld)ForgeWorldMP.inst).toMP().restartMillis - System.currentTimeMillis()))}));
        }
        if (FTBUConfigBackups.enabled.getAsBoolean()) {
            this.println(FTBULang.timer_backup.textComponent(new Object[]{LMStringUtils.getTimeString((long)(Backups.nextBackup - System.currentTimeMillis()))}));
        }
        if (FTBUConfigGeneral.server_info_difficulty.getAsBoolean()) {
            this.println(FTBLibLang.difficulty.textComponent(new Object[]{LMStringUtils.firstUppercase((String)self.getPlayer().field_70170_p.func_175659_aa().toString().toLowerCase())}));
        }
        if (FTBUConfigGeneral.server_info_mode.getAsBoolean()) {
            this.println(FTBLibLang.mode_current.textComponent(new Object[]{LMStringUtils.firstUppercase((String)ForgeWorldMP.inst.getMode().toString().toLowerCase())}));
        }
        InfoPage topsPage = this.getSub("tops").setTitle(FTBUTops.LANG_TOP_TITLE.textComponent(new Object[0]));
        for (StatBase statBase : TopRegistry.getKeys()) {
            InfoPage thisTop = topsPage.getSub(statBase.field_75975_e).setTitle(statBase.func_150951_e());
            Collections.sort(players, TopRegistry.getComparator(statBase));
            int size = Math.min(players.size(), 250);
            for (int j = 0; j < size; ++j) {
                ForgePlayerMP p = (ForgePlayerMP)players.get(j);
                Object data = null;
                TopRegistry.DataSupplier dataSupplier = TopRegistry.getDataSuppier(statBase);
                if (dataSupplier != null) {
                    data = dataSupplier.getData(p);
                }
                if (data == null) {
                    data = "[null]";
                }
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                sb.append(j + 1);
                sb.append(']');
                sb.append(' ');
                sb.append(p.getProfile().getName());
                sb.append(':');
                sb.append(' ');
                if (!(data instanceof ITextComponent)) {
                    sb.append(data);
                }
                TextComponentString c = new TextComponentString(sb.toString());
                if (p == self) {
                    c.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
                } else if (j < 3) {
                    c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                }
                if (data instanceof ITextComponent) {
                    c.func_150257_a(FTBLib.getChatComponent((Object)data));
                }
                thisTop.println((ITextComponent)c);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventFTBUServerInfo(this, self, isOP));
        InfoPage page = this.getSub("commands").setTitle(FTBLibLang.commands.textComponent(new Object[0]));
        page.clear();
        try {
            for (ICommand c : FTBLib.getAllCommands((MinecraftServer)server, (ICommandSender)self.getPlayer())) {
                try {
                    InfoPage cat = new InfoPage('/' + c.func_71517_b());
                    List al = c.func_71514_a();
                    if (!al.isEmpty()) {
                        for (Object s : al) {
                            cat.printlnText('/' + (String)s);
                        }
                    }
                    if (c instanceof ICustomCommandInfo) {
                        Object s;
                        ArrayList list = new ArrayList();
                        ((ICustomCommandInfo)c).addInfo(server, (ICommandSender)self.getPlayer(), list);
                        s = list.iterator();
                        while (s.hasNext()) {
                            ITextComponent c1 = (ITextComponent)s.next();
                            cat.println(c1);
                        }
                    } else {
                        String usage = c.func_71518_a((ICommandSender)self.getPlayer());
                        if (usage.indexOf(10) != -1) {
                            String[] usageL;
                            for (String s1 : usageL = usage.split("\n")) {
                                cat.printlnText(s1);
                            }
                        } else if (usage.indexOf(37) != -1 || usage.indexOf(47) != -1) {
                            cat.println((ITextComponent)new TextComponentString(usage));
                        } else {
                            cat.println((ITextComponent)new TextComponentTranslation(usage, new Object[0]));
                        }
                    }
                    cat.setParent(page);
                    page.addSub(cat);
                }
                catch (Exception ex1) {
                    TextComponentString cc = new TextComponentString('/' + c.func_71517_b());
                    cc.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                    page.getSub('/' + c.func_71517_b()).setTitle((ITextComponent)cc).printlnText("Errored");
                    if (!FTBLib.DEV_ENV) continue;
                    ex1.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        page = this.getSub("warps").setTitle((ITextComponent)new TextComponentString("Warps"));
        for (String s : FTBUWorldData.getW((ForgeWorld)ForgeWorldMP.inst).toMP().listWarps()) {
            InfoExtendedTextLine infoExtendedTextLine = new InfoExtendedTextLine(page, (ITextComponent)new TextComponentString(s));
            infoExtendedTextLine.setClickAction(new ClickAction(ClickActionType.CMD, (JsonElement)new JsonPrimitive("ftb warp " + s)));
            page.text.add(infoExtendedTextLine);
        }
        page = this.getSub("homes").setTitle((ITextComponent)new TextComponentString("Homes"));
        for (String s : FTBUPlayerData.get((ForgePlayer)self).toMP().listHomes()) {
            InfoExtendedTextLine infoExtendedTextLine = new InfoExtendedTextLine(page, (ITextComponent)new TextComponentString(s));
            infoExtendedTextLine.setClickAction(new ClickAction(ClickActionType.CMD, (JsonElement)new JsonPrimitive("ftb home " + s)));
            page.text.add(infoExtendedTextLine);
        }
        this.cleanup();
        this.sortAll();
    }

    public static class CachedInfo {
        public static final InfoPage main = new InfoPage("server_info").setTitle(FTBUActions.SERVER_INFO.displayName);

        public static void reload() {
            main.clear();
        }
    }
}

