/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.backups;

import com.feed_the_beast.ftbl.util.BroadcastSender;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbu.FTBULang;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.world.backups.ThreadBackup;
import com.latmod.lib.util.LMFileUtils;
import java.io.File;
import java.util.Arrays;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandSaveAll;
import net.minecraft.command.server.CommandSaveOff;
import net.minecraft.command.server.CommandSaveOn;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Backups {
    public static final Logger logger = LogManager.getLogger((String)"FTBU Backups");
    public static File backupsFolder;
    public static long nextBackup;
    public static ThreadBackup thread;
    public static boolean hadPlayer;

    public static void init() {
        File file = backupsFolder = FTBUConfigBackups.folder.getAsString().isEmpty() ? new File(FTBLib.folderMinecraft, "/backups/") : new File(FTBUConfigBackups.folder.getAsString());
        if (!backupsFolder.exists()) {
            backupsFolder.mkdirs();
        }
        thread = null;
        Backups.clearOldBackups();
        logger.info("Backups folder - " + backupsFolder.getAbsolutePath());
    }

    public static boolean run(ICommandSender ics) {
        boolean auto;
        if (thread != null) {
            return false;
        }
        boolean bl = auto = !(ics instanceof EntityPlayerMP);
        if (auto && !FTBUConfigBackups.enabled.getAsBoolean()) {
            return false;
        }
        WorldServer w = FTBLib.getServerWorld();
        if (w == null) {
            return false;
        }
        ITextComponent c = FTBULang.backup_start.textComponent(new Object[]{ics.func_70005_c_()});
        c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
        BroadcastSender.inst.func_145747_a(c);
        nextBackup = System.currentTimeMillis() + FTBUConfigBackups.backupMillis();
        if (auto && FTBUConfigBackups.need_online_players.getAsBoolean()) {
            if (!FTBLib.hasOnlinePlayers() && !hadPlayer) {
                return true;
            }
            hadPlayer = false;
        }
        try {
            new CommandSaveOff().func_184881_a(FTBLib.getServer(), (ICommandSender)FTBLib.getServer(), new String[0]);
            new CommandSaveAll().func_184881_a(FTBLib.getServer(), (ICommandSender)FTBLib.getServer(), new String[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        File wd = w.func_72860_G().func_75765_b();
        if (FTBUConfigBackups.use_separate_thread.getAsBoolean()) {
            thread = new ThreadBackup(wd);
            thread.start();
        } else {
            ThreadBackup.doBackup(wd);
        }
        return true;
    }

    public static void clearOldBackups() {
        Object[] s = backupsFolder.list();
        if (s.length > FTBUConfigBackups.backups_to_keep.getAsInt()) {
            Arrays.sort(s);
            int j = s.length - FTBUConfigBackups.backups_to_keep.getAsInt();
            logger.info("Deleting " + j + " old backups");
            for (int i = 0; i < j; ++i) {
                File f = new File(backupsFolder, (String)s[i]);
                if (!f.isDirectory()) continue;
                logger.info("Deleted old backup: " + f.getPath());
                LMFileUtils.delete((File)f);
            }
        }
    }

    public static void postBackup() {
        try {
            new CommandSaveOn().func_184881_a(FTBLib.getServer(), (ICommandSender)FTBLib.getServer(), new String[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        nextBackup = -1L;
        thread = null;
        hadPlayer = false;
    }
}

