/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.backups;

import com.feed_the_beast.ftbl.util.BroadcastSender;
import com.feed_the_beast.ftbu.FTBULang;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.world.backups.Backups;
import com.latmod.lib.Time;
import com.latmod.lib.math.MathHelperLM;
import com.latmod.lib.util.LMFileUtils;
import com.latmod.lib.util.LMStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ThreadBackup
extends Thread {
    public boolean isDone = false;
    private File src0;

    public ThreadBackup(File w) {
        this.src0 = w;
        this.setPriority(7);
    }

    public static void doBackup(File src) {
        block11: {
            Time time = Time.now();
            File dstFile = null;
            try {
                StringBuilder out = new StringBuilder();
                ThreadBackup.appendNum(out, time.year, '-');
                ThreadBackup.appendNum(out, time.month, '-');
                ThreadBackup.appendNum(out, time.day, '-');
                ThreadBackup.appendNum(out, time.hours, '-');
                ThreadBackup.appendNum(out, time.minutes, '-');
                ThreadBackup.appendNum(out, time.seconds, File.separatorChar);
                List files = LMFileUtils.listAll((File)src);
                int allFiles = files.size();
                Backups.logger.info("Backing up " + files.size() + " files...");
                if (FTBUConfigBackups.compression_level.getAsInt() > 0) {
                    out.append("backup.zip");
                    dstFile = LMFileUtils.newFile((File)new File(Backups.backupsFolder, out.toString()));
                    long start = System.currentTimeMillis();
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
                    zos.setLevel(FTBUConfigBackups.compression_level.getAsInt());
                    long logMillis = System.currentTimeMillis() + 5000L;
                    byte[] buffer = new byte[4096];
                    Backups.logger.info("Compressing " + allFiles + " files!");
                    for (int i = 0; i < allFiles; ++i) {
                        int len;
                        File file = (File)files.get(i);
                        String filePath = file.getAbsolutePath();
                        ZipEntry ze = new ZipEntry(src.getName() + File.separator + filePath.substring(src.getAbsolutePath().length() + 1, filePath.length()));
                        long millis = System.currentTimeMillis();
                        if (i == 0 || millis > logMillis || i == allFiles - 1) {
                            logMillis = millis + 5000L;
                            Backups.logger.info("[" + i + " | " + MathHelperLM.toSmallDouble((double)((double)i / (double)allFiles * 100.0)) + "%]: " + ze.getName());
                        }
                        zos.putNextEntry(ze);
                        FileInputStream fis = new FileInputStream(file);
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        fis.close();
                    }
                    zos.close();
                    Backups.logger.info("Done compressing in " + ThreadBackup.getDoneTime(start) + " seconds (" + LMFileUtils.getSizeS((File)dstFile) + ")!");
                } else {
                    out.append(src.getName());
                    dstFile = new File(Backups.backupsFolder, out.toString());
                    dstFile.mkdirs();
                    String dstPath = dstFile.getAbsolutePath() + File.separator;
                    String srcPath = src.getAbsolutePath();
                    long logMillis = System.currentTimeMillis() + 2000L;
                    for (int i = 0; i < allFiles; ++i) {
                        File file = (File)files.get(i);
                        long millis = System.currentTimeMillis();
                        if (i == 0 || millis > logMillis || i == allFiles - 1) {
                            logMillis = millis + 2000L;
                            Backups.logger.info("[" + i + " | " + MathHelperLM.toSmallDouble((double)((double)i / (double)allFiles * 100.0)) + "%]: " + file.getName());
                        }
                        File dst1 = new File(dstPath + file.getAbsolutePath().replace(srcPath, ""));
                        LMFileUtils.copyFile((File)file, (File)dst1);
                    }
                }
                Backups.logger.info("Created " + dstFile.getAbsolutePath() + " from " + src.getAbsolutePath());
                Backups.clearOldBackups();
                if (FTBUConfigBackups.display_file_size.getAsBoolean()) {
                    String sizeB = LMFileUtils.getSizeS((File)dstFile);
                    String sizeT = LMFileUtils.getSizeS((File)Backups.backupsFolder);
                    ITextComponent c = FTBULang.backup_end_2.textComponent(new Object[]{ThreadBackup.getDoneTime(time.millis), sizeB.equals(sizeT) ? sizeB : sizeB + " | " + sizeT});
                    c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                    BroadcastSender.inst.func_145747_a(c);
                } else {
                    ITextComponent c = FTBULang.backup_end_1.textComponent(new Object[]{ThreadBackup.getDoneTime(time.millis)});
                    c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                    BroadcastSender.inst.func_145747_a(c);
                }
            }
            catch (Exception ex) {
                ITextComponent c = FTBULang.backup_fail.textComponent(new Object[]{ex.getClass().getName()});
                c.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                BroadcastSender.inst.func_145747_a(c);
                ex.printStackTrace();
                if (dstFile == null) break block11;
                LMFileUtils.delete(dstFile);
            }
        }
    }

    private static String getDoneTime(long l) {
        return LMStringUtils.getTimeString((long)(System.currentTimeMillis() - l));
    }

    private static void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    @Override
    public void run() {
        this.isDone = false;
        ThreadBackup.doBackup(this.src0);
        this.isDone = true;
    }
}

