/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.chunks;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.LangKey;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbu.world.data.FTBUTeamData;
import net.minecraft.util.math.BlockPos;

public final class ClaimedChunk {
    public static final LangKey LANG_WILDERNESS = new LangKey("ftbu.chunktype.wilderness");
    public static final LangKey LANG_CLAIMED = new LangKey("ftbu.chunktype.claimed");
    public static final LangKey LANG_LOADED = new LangKey("ftbu.chunktype.loaded");
    public final ForgeWorld world;
    public final ChunkDimPos pos;
    public final ForgePlayer owner;
    public boolean loaded;
    public boolean forced;

    public ClaimedChunk(ForgeWorld w, ForgePlayer o, ChunkDimPos p) {
        this.world = w;
        this.pos = p;
        this.owner = o;
    }

    public boolean equals(Object o) {
        return o != null && (o == this || o instanceof ClaimedChunk && this.pos.equalsChunk(((ClaimedChunk)o).pos));
    }

    public String toString() {
        return this.pos.toString();
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public boolean isChunkOwner(ForgePlayer p) {
        return p != null && p.equalsPlayer(this.owner);
    }

    public boolean canInteract(ForgePlayerMP p, boolean leftClick, BlockPos pos) {
        if (this.owner.equalsPlayer((ForgePlayer)p)) {
            return true;
        }
        if (!this.owner.hasTeam()) {
            return true;
        }
        if (p.isFake()) {
            return FTBUTeamData.get((ForgeTeam)this.owner.getTeam()).toMP().fakePlayers.getAsBoolean();
        }
        return this.owner.getTeam().getStatus((ForgePlayer)p).isAlly();
    }
}

