/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.chunks;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ClaimedChunkStorage {
    private final Map<ChunkDimPos, ClaimedChunk> map = new HashMap<ChunkDimPos, ClaimedChunk>();
    private final Map<UUID, Collection<ClaimedChunk>> invertedMap = new HashMap<UUID, Collection<ClaimedChunk>>();

    @Nonnull
    public Collection<ClaimedChunk> getAllChunks() {
        return this.map.values();
    }

    @Nullable
    public ClaimedChunk getChunk(@Nonnull ChunkDimPos pos) {
        return this.map.get(pos);
    }

    public void put(@Nonnull ChunkDimPos pos, @Nullable ClaimedChunk c) {
        if (c == null) {
            Collection<ClaimedChunk> ch;
            ClaimedChunk chunk = this.map.remove(pos);
            if (chunk != null && (ch = this.invertedMap.get(chunk.owner.getProfile().getId())) != null) {
                ch.remove(chunk);
            }
        } else {
            this.map.put(c.pos, c);
            Collection<ClaimedChunk> ch = this.invertedMap.get(c.owner.getProfile().getId());
            if (ch == null) {
                ch = new HashSet<ClaimedChunk>();
                this.invertedMap.put(c.owner.getProfile().getId(), ch);
            }
            ch.add(c);
        }
    }

    @Nonnull
    public Collection<ClaimedChunk> getChunks(@Nonnull UUID playerID) {
        Collection<ClaimedChunk> c = this.invertedMap.get(playerID);
        return c == null ? Collections.EMPTY_SET : c;
    }

    public int getClaimedChunks(@Nonnull UUID playerID) {
        Collection<ClaimedChunk> c = this.invertedMap.get(playerID);
        return c == null ? 0 : c.size();
    }

    public int getLoadedChunks(@Nonnull UUID playerID) {
        Collection<ClaimedChunk> c = this.invertedMap.get(playerID);
        if (c == null || c.isEmpty()) {
            return 0;
        }
        int loaded = 0;
        for (ClaimedChunk chunk : c) {
            if (!chunk.loaded) continue;
            ++loaded;
        }
        return loaded;
    }

    public ForgePlayer getOwnerPlayer(ChunkDimPos pos) {
        ClaimedChunk c = this.map.get(pos);
        return c == null ? null : c.owner;
    }
}

