/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.data;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.config.ConfigEntryBool;
import com.feed_the_beast.ftbl.util.BlockDimPos;
import com.feed_the_beast.ftbl.util.LMNBTUtils;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.world.data.FTBUPlayerData;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataMP;
import com.latmod.lib.io.Bits;
import com.latmod.lib.util.LMTroveUtils;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUPlayerDataMP
extends FTBUPlayerData
implements INBTSerializable<NBTTagCompound> {
    public final ConfigEntryBool chatLinks = new ConfigEntryBool(true);
    private Map<String, BlockDimPos> homes;

    @Override
    public FTBUPlayerDataMP toMP() {
        return this;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        byte flags = tag.func_74771_c("Flags");
        this.renderBadge.set(Bits.getBit((byte)flags, (byte)0));
        this.chatLinks.set(Bits.getBit((byte)flags, (byte)1));
        if (tag.func_74764_b("Homes")) {
            this.homes = new HashMap<String, BlockDimPos>();
            NBTTagCompound tag1 = (NBTTagCompound)tag.func_74781_a("Homes");
            if (tag1 != null && !tag1.func_82582_d()) {
                for (String s1 : LMNBTUtils.getMapKeys((NBTTagCompound)tag1)) {
                    this.setHome(s1.toLowerCase(), new BlockDimPos(tag1.func_74759_k(s1)));
                }
            }
        } else {
            this.homes = null;
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        byte flags = 0;
        flags = Bits.setBit((byte)flags, (byte)0, (boolean)this.renderBadge.getAsBoolean());
        if ((flags = Bits.setBit((byte)flags, (byte)1, (boolean)this.chatLinks.getAsBoolean())) != 0) {
            tag.func_74774_a("Flags", flags);
        }
        if (this.homes != null && !this.homes.isEmpty()) {
            NBTTagCompound tag1 = new NBTTagCompound();
            for (Map.Entry<String, BlockDimPos> e : this.homes.entrySet()) {
                tag1.func_74783_a(e.getKey(), e.getValue().toIntArray());
            }
            tag.func_74782_a("Homes", (NBTBase)tag1);
        }
        return tag;
    }

    @Override
    public void writeSyncData(ForgePlayer player, NBTTagCompound tag, boolean self) {
        TIntIntHashMap map = new TIntIntHashMap();
        if (this.renderBadge.getAsBoolean()) {
            map.put(0, 1);
        }
        if (self) {
            LMTroveUtils.put((TIntIntMap)map, (int)10, (int)FTBUWorldDataMP.chunks.getClaimedChunks(player.getProfile().getId()), (int)0);
            LMTroveUtils.put((TIntIntMap)map, (int)11, (int)FTBUWorldDataMP.chunks.getLoadedChunks(player.getProfile().getId()), (int)0);
            LMTroveUtils.put((TIntIntMap)map, (int)12, (int)FTBUPermissions.CLAIMS_MAX_CHUNKS.get(player.getProfile()), (int)0);
            LMTroveUtils.put((TIntIntMap)map, (int)13, (int)FTBUPermissions.CHUNKLOADER_MAX_CHUNKS.get(player.getProfile()), (int)0);
        }
        if (!map.isEmpty()) {
            tag.func_74783_a("F", LMTroveUtils.toIntList((TIntIntMap)map).toArray());
        }
    }

    public Collection<String> listHomes() {
        if (this.homes == null || this.homes.isEmpty()) {
            return Collections.emptySet();
        }
        return this.homes.keySet();
    }

    public BlockDimPos getHome(String s) {
        return this.homes == null ? null : this.homes.get(s.toLowerCase());
    }

    public boolean setHome(String s, BlockDimPos pos) {
        if (pos == null) {
            return this.homes != null && this.homes.remove(s) != null;
        }
        if (this.homes == null) {
            this.homes = new HashMap<String, BlockDimPos>();
        }
        return this.homes.put(s, pos.copy()) == null;
    }

    public int homesSize() {
        return this.homes == null ? 0 : this.homes.size();
    }
}

