/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.data;

import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.config.ConfigEntryBool;
import com.feed_the_beast.ftbl.api.config.ConfigEntryEnum;
import com.feed_the_beast.ftbl.api.security.EnumTeamPrivacyLevel;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.data.FTBUTeamData;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataMP;
import com.latmod.lib.io.Bits;
import com.latmod.lib.util.LMUtils;
import java.util.Collection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUTeamDataMP
extends FTBUTeamData
implements INBTSerializable<NBTTagCompound> {
    public final ConfigEntryEnum<EnumTeamPrivacyLevel> blocks = new ConfigEntryEnum((Enum)EnumTeamPrivacyLevel.ALLIES, EnumTeamPrivacyLevel.NAME_MAP);
    public final ConfigEntryBool disable_explosions = new ConfigEntryBool(false);
    public final ConfigEntryBool fakePlayers = new ConfigEntryBool(false);

    @Override
    public FTBUTeamDataMP toMP() {
        return this;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        byte flags = tag.func_74771_c("Flags");
        this.disable_explosions.set(Bits.getBit((byte)flags, (byte)0));
        this.fakePlayers.set(Bits.getBit((byte)flags, (byte)1));
        this.blocks.setIndex(tag.func_74764_b("BlockSecurity") ? tag.func_74771_c("BlockSecurity") : this.blocks.defValue);
        if (tag.func_74764_b("ClaimedChunks")) {
            NBTTagCompound tag1 = tag.func_74775_l("ClaimedChunks");
            for (String s : tag1.func_150296_c()) {
                ForgePlayerMP player = ForgeWorldMP.inst.getPlayer((Object)LMUtils.fromString((String)s));
                if (player == null || !player.isMemberOf(ForgeWorldMP.currentTeam)) continue;
                NBTTagList list = tag1.func_150295_c(s, 11);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    int[] ai = list.func_150306_c(i);
                    if (ai.length < 3) continue;
                    ClaimedChunk chunk = new ClaimedChunk((ForgeWorld)ForgeWorldMP.inst, (ForgePlayer)player, new ChunkDimPos(ai[0], ai[1], ai[2]));
                    if (ai.length >= 4) {
                        chunk.loaded = ai[3] != 0;
                    }
                    FTBUWorldDataMP.chunks.put(chunk.pos, chunk);
                }
            }
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        byte flags = 0;
        flags = Bits.setBit((byte)flags, (byte)0, (boolean)this.disable_explosions.getAsBoolean());
        if ((flags = Bits.setBit((byte)flags, (byte)1, (boolean)this.fakePlayers.getAsBoolean())) != 0) {
            tag.func_74774_a("Flags", flags);
        }
        if (!this.blocks.isDefault()) {
            tag.func_74774_a("BlockSecurity", (byte)this.blocks.getIndex());
        }
        NBTTagCompound chunksTag = new NBTTagCompound();
        for (ForgePlayer player : ForgeWorldMP.currentTeam.getMembers()) {
            Collection<ClaimedChunk> chunks = FTBUWorldDataMP.chunks.getChunks(player.getProfile().getId());
            if (chunks.isEmpty()) continue;
            NBTTagList tag1 = new NBTTagList();
            for (ClaimedChunk c : chunks) {
                int[] ai = c.loaded ? new int[4] : new int[3];
                ai[0] = c.pos.dim;
                ai[1] = c.pos.field_77276_a;
                ai[2] = c.pos.field_77275_b;
                if (c.loaded) {
                    ai[3] = 1;
                }
                tag1.func_74742_a((NBTBase)new NBTTagIntArray(ai));
            }
            chunksTag.func_74782_a(player.getStringUUID(), (NBTBase)tag1);
        }
        if (!chunksTag.func_82582_d()) {
            tag.func_74782_a("ClaimedChunks", (NBTBase)chunksTag);
        }
        return tag;
    }
}

