/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.data;

import com.feed_the_beast.ftbl.FTBLibLang;
import com.feed_the_beast.ftbl.api.ForgePlayer;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorld;
import com.feed_the_beast.ftbl.api.notification.Notification;
import com.feed_the_beast.ftbl.util.BlockDimPos;
import com.feed_the_beast.ftbl.util.BroadcastSender;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbl.util.LMDimUtils;
import com.feed_the_beast.ftbl.util.LMNBTUtils;
import com.feed_the_beast.ftbu.FTBU;
import com.feed_the_beast.ftbu.FTBULang;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.badges.Badge;
import com.feed_the_beast.ftbu.badges.BadgeStorage;
import com.feed_the_beast.ftbu.cmd.CmdRestart;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.config.FTBUConfigGeneral;
import com.feed_the_beast.ftbu.handlers.FTBUChunkEventHandler;
import com.feed_the_beast.ftbu.net.MessageAreaUpdate;
import com.feed_the_beast.ftbu.ranks.Ranks;
import com.feed_the_beast.ftbu.world.backups.Backups;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunkStorage;
import com.feed_the_beast.ftbu.world.data.FTBUTeamData;
import com.feed_the_beast.ftbu.world.data.FTBUWorldData;
import com.google.gson.JsonArray;
import com.latmod.lib.EnumEnabled;
import com.latmod.lib.json.LMJsonUtils;
import com.latmod.lib.math.MathHelperLM;
import com.latmod.lib.util.LMStringUtils;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUWorldDataMP
extends FTBUWorldData
implements ITickable,
INBTSerializable<NBTTagCompound> {
    public static final BadgeStorage localBadges = new BadgeStorage();
    public static ClaimedChunkStorage chunks;
    public long restartMillis;
    private long nextChunkloaderUpdate;
    private Map<String, BlockDimPos> warps;
    private String lastRestartMessage;

    public static Badge getServerBadge(ForgePlayerMP p) {
        if (p == null) {
            return null;
        }
        Badge b = FTBUWorldDataMP.localBadges.badgePlayerMap.get(p.getProfile().getId());
        if (b != null) {
            return b;
        }
        String rank = Ranks.instance().getRankOf((GameProfile)p.getProfile()).badge;
        if (!rank.isEmpty() && (b = FTBUWorldDataMP.localBadges.badgeMap.get(rank)) != null) {
            return b;
        }
        return null;
    }

    public static void reloadServerBadges() {
        try {
            localBadges.clear();
            localBadges.loadBadges(LMJsonUtils.fromJson((File)new File(FTBLib.folderLocal, "ftbu/badges.json")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isInSpawn(@Nonnull ChunkDimPos pos) {
        if (pos.dim != 0 || !FTBLib.getServer().func_71262_S() && !FTBUConfigGeneral.spawn_area_in_sp.getAsBoolean()) {
            return false;
        }
        int radius = FTBLib.getServer().func_82357_ak();
        if (radius <= 0) {
            return false;
        }
        BlockPos c = FTBLib.getServer().func_130014_f_().func_175694_M();
        int minX = MathHelperLM.chunk((double)((double)c.func_177958_n() + 0.5 - (double)radius));
        int minZ = MathHelperLM.chunk((double)((double)c.func_177952_p() + 0.5 - (double)radius));
        int maxX = MathHelperLM.chunk((double)((double)c.func_177958_n() + 0.5 + (double)radius));
        int maxZ = MathHelperLM.chunk((double)((double)c.func_177952_p() + 0.5 + (double)radius));
        return pos.field_77276_a >= minX && pos.field_77276_a <= maxX && pos.field_77275_b >= minZ && pos.field_77275_b <= maxZ;
    }

    public static boolean isInSpawnD(int dim, double x, double z) {
        return dim == 0 && FTBUWorldDataMP.isInSpawn(new ChunkDimPos(dim, MathHelperLM.chunk((double)x), MathHelperLM.chunk((double)z)));
    }

    public static boolean isDimensionBlacklisted(GameProfile profile, int dim) {
        JsonArray a = FTBUPermissions.CLAIMS_DIMENSION_BLACKLIST.getJson(profile).getAsJsonArray();
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).getAsInt() != dim) continue;
            return true;
        }
        return false;
    }

    public static boolean allowExplosion(World world, Explosion explosion) {
        ChunkDimPos pos = new ChunkDimPos(world.field_73011_w.getDimension(), MathHelperLM.chunk((double)explosion.getPosition().field_72450_a), MathHelperLM.chunk((double)explosion.getPosition().field_72449_c));
        if (pos.dim == 0 && FTBUConfigGeneral.safe_spawn.getAsBoolean() && FTBUWorldDataMP.isInSpawn(pos)) {
            return false;
        }
        ClaimedChunk c = chunks.getChunk(pos);
        if (c != null) {
            EnumEnabled fe = (EnumEnabled)FTBUPermissions.CLAIMS_FORCED_EXPLOSIONS.get(c.owner.getProfile());
            if (fe == null) {
                return !c.owner.hasTeam() || !FTBUTeamData.get((ForgeTeam)c.owner.getTeam()).toMP().disable_explosions.getAsBoolean();
            }
            return fe == EnumEnabled.ENABLED;
        }
        return true;
    }

    public static boolean claimChunk(ForgePlayerMP player, ChunkDimPos pos) {
        if (FTBUWorldDataMP.isDimensionBlacklisted(player.getProfile(), pos.dim)) {
            return false;
        }
        if (!player.hasTeam()) {
            EntityPlayerMP ep = player.getPlayer();
            if (ep != null) {
                Notification.error((String)"no_team", (ITextComponent)FTBLibLang.team_no_team.textComponent(new Object[0])).sendTo(ep);
            }
            return false;
        }
        int max = FTBUPermissions.CLAIMS_MAX_CHUNKS.get(player.getProfile());
        if (max == 0) {
            return false;
        }
        if (chunks.getClaimedChunks(player.getProfile().getId()) >= max) {
            return false;
        }
        ClaimedChunk chunk = chunks.getChunk(pos);
        if (chunk != null) {
            return false;
        }
        chunks.put(pos, new ClaimedChunk((ForgeWorld)player.getWorld(), (ForgePlayer)player, pos));
        player.sendUpdate();
        return true;
    }

    public static boolean unclaimChunk(@Nonnull ForgePlayerMP player, @Nonnull ChunkDimPos pos) {
        ClaimedChunk chunk = chunks.getChunk(pos);
        if (chunk != null && chunk.isChunkOwner((ForgePlayer)player)) {
            FTBUWorldDataMP.setLoaded(player, pos, false);
            chunks.put(pos, null);
            player.sendUpdate();
            return true;
        }
        return false;
    }

    public static void unclaimAllChunks(@Nonnull ForgePlayerMP player, @Nullable Integer dim) {
        HashSet<ClaimedChunk> ch = new HashSet<ClaimedChunk>();
        ch.addAll(chunks.getChunks(player.getProfile().getId()));
        if (!ch.isEmpty()) {
            for (ClaimedChunk c : ch) {
                if (dim != null && dim != c.pos.dim) continue;
                FTBUWorldDataMP.setLoaded(player, c.pos, false);
                chunks.put(c.pos, null);
            }
            player.sendUpdate();
        }
    }

    public static boolean setLoaded(@Nonnull ForgePlayerMP player, @Nonnull ChunkDimPos pos, boolean flag) {
        ClaimedChunk chunk = chunks.getChunk(pos);
        if (chunk != null && flag != chunk.loaded && player.equalsPlayer(chunk.owner)) {
            if (flag) {
                if (!player.hasTeam()) {
                    EntityPlayerMP ep = player.getPlayer();
                    if (ep != null) {
                        Notification.error((String)"no_team", (ITextComponent)FTBLibLang.team_no_team.textComponent(new Object[0])).sendTo(ep);
                    }
                    return false;
                }
                if (FTBUWorldDataMP.isDimensionBlacklisted(player.getProfile(), pos.dim)) {
                    return false;
                }
                int max = FTBUPermissions.CHUNKLOADER_MAX_CHUNKS.get(player.getProfile());
                if (max == 0 || chunks.getLoadedChunks(player.getProfile().getId()) >= max) {
                    return false;
                }
            }
            chunk.loaded = flag;
            FTBUChunkEventHandler.instance.markDirty(LMDimUtils.getWorld((int)pos.dim));
            if (player.getPlayer() != null) {
                new MessageAreaUpdate(pos.field_77276_a, pos.field_77275_b, pos.dim, 1, 1).sendTo(player.toMP().getPlayer());
                player.sendUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public FTBUWorldDataMP toMP() {
        return this;
    }

    @Override
    public void onLoaded() {
        chunks = new ClaimedChunkStorage();
        long startMillis = System.currentTimeMillis();
        Backups.nextBackup = startMillis + FTBUConfigBackups.backupMillis();
        this.lastRestartMessage = "";
        if (FTBUConfigGeneral.restart_timer.getAsInt() > 0) {
            this.restartMillis = startMillis + (long)((double)FTBUConfigGeneral.restart_timer.getAsInt() * 3600.0 * 1000.0);
            FTBU.logger.info("Server restart in " + LMStringUtils.getTimeString((long)this.restartMillis));
        }
        FTBLib.registerServerTickable((MinecraftServer)FTBLib.getServer(), (ITickable)this);
        localBadges.clear();
    }

    @Override
    public void onLoadedBeforePlayers() {
    }

    @Override
    public void onClosed() {
        chunks = null;
        localBadges.clear();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.warps != null && !this.warps.isEmpty()) {
            NBTTagCompound tag1 = new NBTTagCompound();
            for (Map.Entry<String, BlockDimPos> e : this.warps.entrySet()) {
                tag1.func_74783_a(e.getKey(), e.getValue().toIntArray());
            }
            tag.func_74782_a("Warps", (NBTBase)tag1);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.nextChunkloaderUpdate = System.currentTimeMillis() + 10000L;
        if (tag.func_74764_b("Warps")) {
            this.warps = new HashMap<String, BlockDimPos>();
            NBTTagCompound tag1 = (NBTTagCompound)tag.func_74781_a("Warps");
            if (tag1 != null && !tag1.func_82582_d()) {
                for (String s1 : LMNBTUtils.getMapKeys((NBTTagCompound)tag1)) {
                    this.setWarp(s1.toLowerCase(), new BlockDimPos(tag1.func_74759_k(s1)));
                }
            }
        } else {
            this.warps = null;
        }
    }

    public void func_73660_a() {
        int secondsLeft;
        String msg;
        long now = System.currentTimeMillis();
        if (this.restartMillis > 0L && !this.lastRestartMessage.equals(msg = LMStringUtils.getTimeString((long)((long)(secondsLeft = (int)((this.restartMillis - System.currentTimeMillis()) / 1000L)) * 1000L)))) {
            this.lastRestartMessage = msg;
            if (secondsLeft <= 0) {
                CmdRestart.restart();
                return;
            }
            if (secondsLeft <= 10 || secondsLeft == 60 || secondsLeft == 300 || secondsLeft == 600 || secondsLeft == 1800) {
                ITextComponent c = FTBULang.timer_restart.textComponent(new Object[]{msg});
                c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                BroadcastSender.inst.func_145747_a(c);
            }
        }
        if (Backups.nextBackup > 0L && Backups.nextBackup <= now) {
            Backups.run((ICommandSender)FTBLib.getServer());
        }
        if (this.nextChunkloaderUpdate < now) {
            this.nextChunkloaderUpdate = now + 7200L;
            FTBUChunkEventHandler.instance.markDirty(null);
        }
        if (Backups.thread != null && Backups.thread.isDone) {
            Backups.thread = null;
            Backups.postBackup();
        }
    }

    public Collection<String> listWarps() {
        if (this.warps == null || this.warps.isEmpty()) {
            return Collections.emptySet();
        }
        return this.warps.keySet();
    }

    public BlockDimPos getWarp(String s) {
        return this.warps == null ? null : this.warps.get(s);
    }

    public boolean setWarp(String s, BlockDimPos pos) {
        if (pos == null) {
            return this.warps != null && this.warps.remove(s) != null;
        }
        if (this.warps == null) {
            this.warps = new HashMap<String, BlockDimPos>();
        }
        return this.warps.put(s, pos.copy()) == null;
    }

    public int warpsSize() {
        return this.warps == null ? 0 : this.warps.size();
    }
}

