/*
 * Decompiled with CFR 0.152.
 */
package ca.glasspelican.loginshield;

import ca.glasspelican.loginshield.ConfigurationManager;
import ca.glasspelican.loginshield.LogHelper;
import ca.glasspelican.loginshield.findvoid;
import ca.glasspelican.loginshield.status;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

class PlayerManager {
    private static Map<Integer, status> players = new ConcurrentHashMap<Integer, status>();

    PlayerManager() {
    }

    static status get(Integer entityID) {
        return players.get(entityID);
    }

    static status add(EntityPlayer player) {
        status status2 = new status(player);
        status2.setTimeProtected(ConfigurationManager.getProtectTime());
        players.put(player.func_145782_y(), status2);
        return status2;
    }

    static void remove(Integer entityID) {
        players.remove(entityID);
    }

    static Set<Map.Entry<Integer, status>> entrySet() {
        return players.entrySet();
    }

    static void teleportPlayerSpawn(status player) {
        PlayerManager.teleportPlayer(player, true);
    }

    static void teleportPlayer(status player) {
        PlayerManager.teleportPlayer(player, false);
    }

    private static void teleportPlayer(status player, boolean spawn) {
        BlockPos targetBlockPos;
        World playerWorld = player.getPlayerEntity().func_130014_f_();
        int dim = playerWorld.func_175624_G().func_82747_f();
        if (spawn) {
            try {
                targetBlockPos = playerWorld.func_175694_M();
            }
            catch (Exception exp) {
                LogHelper.fatal("Error getting spawn point for player: Aborting");
                LogHelper.debug(exp.getLocalizedMessage());
                return;
            }
        } else {
            targetBlockPos = player.getPlayerEntity().func_180425_c();
        }
        BlockPos blockPos = findvoid.FindVoid(playerWorld, targetBlockPos);
        player.getPlayerEntity().func_70634_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5);
        player.setStartBlockPos(blockPos);
        LogHelper.info("Teleporting player: " + player.getPlayerEntity().getDisplayNameString() + " in dim: " + dim);
    }

    static void sendChatMessage(status player, String msg) {
        if (msg.isEmpty()) {
            return;
        }
        player.getPlayerEntity().func_146105_b((ITextComponent)new TextComponentString(msg));
    }
}

