/*
 * Decompiled with CFR 0.152.
 */
package ca.glasspelican.loginshield;

import ca.glasspelican.loginshield.ConfigurationManager;
import ca.glasspelican.loginshield.LogHelper;
import ca.glasspelican.loginshield.PlayerManager;
import ca.glasspelican.loginshield.status;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="login_shield", version="1.10.2-11-gb29eaad", acceptableRemoteVersions="*", guiFactory="ca.glasspelican.loginshield.client.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class loginshield {
    public static final String MODID = "login_shield";
    public static final String VERSION = "1.10.2-11-gb29eaad";
    public static final String CHARSET = "UTF-8";

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        ConfigurationManager.LoadConfiguration(config);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        status thisPlayer = PlayerManager.add(event.player);
        if (!thisPlayer.getPlayerEntity().func_130014_f_().func_175623_d(thisPlayer.getStartBlockPos()) && thisPlayer.getPlayerEntity().func_130014_f_().func_175623_d(thisPlayer.getAboveStartBlockPos())) {
            LogHelper.info("Block conflicting with player");
            if (ConfigurationManager.isBlockConflict()) {
                PlayerManager.teleportPlayer(thisPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerManager.remove(event.player.func_145782_y());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!ConfigurationManager.isVoidTeleport()) {
            return;
        }
        Iterator<Map.Entry<Integer, status>> iterator = PlayerManager.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, status> object;
            Map.Entry<Integer, status> pair = object = iterator.next();
            status thisPlayer = pair.getValue();
            if (thisPlayer.hasInteracted.booleanValue()) continue;
            if (thisPlayer.getStartX().intValue() != thisPlayer.getCurrentPos().func_177958_n() || thisPlayer.getStartZ().intValue() != thisPlayer.getCurrentPos().func_177952_p()) {
                thisPlayer.hasInteracted = true;
            }
            if (!thisPlayer.isTimeProtected() || thisPlayer.getCurrentPos().func_177956_o() >= 0) continue;
            PlayerManager.teleportPlayerSpawn(thisPlayer);
            PlayerManager.sendChatMessage(thisPlayer, ConfigurationManager.getVoidRescueMessage());
        }
    }

    @SubscribeEvent
    public void OnLivingAttack(LivingHurtEvent event) {
        status player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = PlayerManager.get(event.getEntityLiving().func_145782_y())).isTimeProtected() && !player.hasInteracted.booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void OnPlayerInteract(PlayerInteractEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            status player = PlayerManager.get(event.getEntityLiving().func_145782_y());
            if (player == null) {
                return;
            }
            player.hasInteracted = true;
        }
    }

    @SubscribeEvent
    public void OnPlayerAttack(AttackEntityEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            status player = PlayerManager.get(event.getEntityLiving().func_145782_y());
            if (player == null) {
                return;
            }
            player.hasInteracted = true;
        }
    }

    @SubscribeEvent
    public void OnPlayerItemDrop(ItemTossEvent event) {
        status player = PlayerManager.get(event.getPlayer().func_145782_y());
        if (player == null) {
            return;
        }
        player.hasInteracted = true;
    }

    @SubscribeEvent
    public void OnPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        status player = PlayerManager.get(event.player.func_145782_y());
        if (player == null) {
            return;
        }
        int dimensionTime = ConfigurationManager.getDimensionTime();
        if (dimensionTime >= 0) {
            player.hasInteracted = false;
            player.setTimeProtected(dimensionTime);
            player.setStartBlockPos(event.player.func_180425_c());
        }
    }

    @SubscribeEvent
    public void OnAiTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer) {
            status player = PlayerManager.get(event.getTarget().func_145782_y());
            if (player == null) {
                return;
            }
            if (player.hasInteracted.booleanValue()) {
                return;
            }
            event.getEntityLiving().func_70604_c(null);
            event.getEntityLiving().field_70755_b = null;
            if (event.getEntityLiving() instanceof EntityLiving) {
                ((EntityLiving)event.getEntityLiving()).field_70696_bz = null;
            }
        }
    }

    @SubscribeEvent
    public void OnConfigurationChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigurationManager.save();
        }
    }
}

