/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.yeoldetanks;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.shadowfacts.config.Config;
import net.shadowfacts.config.ConfigManager;
import net.shadowfacts.yeoldetanks.YeOldeTanks;

@Config(name="YeOldeTanks")
public class YOTConfig {
    public static Configuration config;
    @Config.Prop(description="The capacity of the barrel in milibuckets")
    public static int barrelCapacity;
    @Config.Prop(description="Can the barrel be filled from any side.\nBy default, it can only be filled from the top if the lid is off.")
    public static boolean fillFromAnySide;
    @Config.Prop(description="Can the barrel be drained from any side.\nBy default, it can only be drained from the bottom")
    public static boolean drainFromAnySide;
    @Config.Prop(description="Render the fluid contained in the barrel")
    public static boolean renderFluid;
    @Config.Prop(description="Automatically output to the bottom")
    public static boolean autoOutputBottom;
    @Config.Prop(description="Mystical, magical stuff and things", category="misc", name="#BlameEllpeck")
    public static boolean blameEllpeck;

    public static void init(FMLPreInitializationEvent event) {
        config = new Configuration(new File(event.getModConfigurationDirectory(), "YeOldeTanks.cfg"));
        YOTConfig.load();
    }

    public static void load() {
        YeOldeTanks.log.info("Loading config");
        config.load();
        ConfigManager.load(YOTConfig.class, Configuration.class, (Object)config);
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        barrelCapacity = 55000;
        fillFromAnySide = false;
        drainFromAnySide = false;
        renderFluid = true;
        autoOutputBottom = true;
        blameEllpeck = false;
    }
}

