/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.yeoldetanks.block.barrel;

import java.util.Arrays;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.shadowfacts.shadowmc.ShadowMC;
import net.shadowfacts.shadowmc.capability.CapHolder;
import net.shadowfacts.shadowmc.fluid.FluidTank;
import net.shadowfacts.shadowmc.nbt.AutoSerializeNBT;
import net.shadowfacts.shadowmc.network.PacketRequestTEUpdate;
import net.shadowfacts.shadowmc.tileentity.BaseTileEntity;
import net.shadowfacts.yeoldetanks.YOTConfig;

@Optional.InterfaceList(value={@Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.SimpleComponent"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.ManagedPeripheral")})
public class TileEntityBarrel
extends BaseTileEntity
implements ITickable,
SimpleComponent,
ManagedPeripheral {
    @AutoSerializeNBT
    @CapHolder(capabilities={IFluidHandler.class})
    public FluidTank tank = new FluidTank(YOTConfig.barrelCapacity);
    private int prevAmount = this.tank.getFluidAmount();
    private static String[] methodNames = new String[]{"getFluid", "getFluidAmount"};
    private static List<String> methodList = Arrays.asList(methodNames);
    private static String peripheralName = "yot_barrel";

    void save() {
        this.func_70296_d();
        if (Math.abs(this.prevAmount - this.tank.getFluidAmount()) >= 1000) {
            this.prevAmount = this.tank.getFluidAmount();
            if (!this.field_145850_b.field_72995_K) {
                this.sync();
            }
        }
    }

    public void func_73660_a() {
        TileEntity te;
        if (YOTConfig.autoOutputBottom && this.tank.getFluid() != null && this.tank.getFluidAmount() > 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
            this.tank.drain(fluidHandler.fill(this.tank.drain(this.tank.getCapacity(), false), true), true);
        }
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            ShadowMC.network.sendToServer((IMessage)new PacketRequestTEUpdate((BaseTileEntity)this));
        }
    }

    public String[] methods() {
        return methodNames;
    }

    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        int methodId = methodList.indexOf(method);
        switch (methodId) {
            case 0: {
                return new Object[]{this.tank.getFluid().getLocalizedName()};
            }
            case 1: {
                return new Object[]{this.tank.getFluidAmount()};
            }
        }
        throw new RuntimeException("No such method");
    }

    public String getComponentName() {
        return peripheralName;
    }
}

