/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.yeoldetanks.block.creativebarrel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.shadowfacts.shadowmc.achievement.AchievementProvider;
import net.shadowfacts.shadowmc.item.ItemModelProvider;
import net.shadowfacts.yeoldetanks.CoFHUtils;
import net.shadowfacts.yeoldetanks.YeOldeTanks;
import net.shadowfacts.yeoldetanks.achievement.ModAchievements;
import net.shadowfacts.yeoldetanks.block.creativebarrel.TileEntityCreativeBarrel;

public class BlockCreativeBarrel
extends Block
implements ItemModelProvider,
AchievementProvider {
    public static final PropertyBool LID = PropertyBool.func_177716_a((String)"lid");
    private static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    private static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    private static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockCreativeBarrel() {
        super(Material.field_151576_e);
        this.func_149663_c("creativeBarrel");
        this.setRegistryName("creativeBarrel");
        this.func_149647_a(YeOldeTanks.tab);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LID, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LID});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LID) != false ? 1 : 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LID, (Comparable)Boolean.valueOf(meta == 1));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        BlockCreativeBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        BlockCreativeBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockCreativeBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockCreativeBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockCreativeBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te;
        if (entity.field_70165_t > (double)pos.func_177958_n() && entity.field_70165_t < (double)(pos.func_177958_n() + 1) && entity.field_70163_u > (double)pos.func_177956_o() && entity.field_70163_u < (double)(pos.func_177956_o() + 1) && entity.field_70161_v > (double)pos.func_177952_p() && entity.field_70161_v < (double)(pos.func_177952_p() + 1) && (te = world.func_175625_s(pos)) instanceof TileEntityCreativeBarrel) {
            Block fluidBlock;
            TileEntityCreativeBarrel barrel = (TileEntityCreativeBarrel)te;
            if (barrel.tank.getFluid() != null && (fluidBlock = barrel.tank.getFluid().getFluid().getBlock()) != null) {
                fluidBlock.func_180634_a(world, pos, state, entity);
            }
        }
    }

    @Nonnull
    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ItemStack dropStack = new ItemStack((Block)YeOldeTanks.blocks.creativeBarrel);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCreativeBarrel) {
            TileEntityCreativeBarrel barrel = (TileEntityCreativeBarrel)te;
            if (barrel.tank.getFluid() != null) {
                dropStack.func_77982_d(new NBTTagCompound());
                barrel.tank.writeToNBT(dropStack.func_77978_p());
            }
        }
        EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), dropStack);
        world.func_72838_d((Entity)item);
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (player.func_184586_b(hand) == null && player.func_70093_af()) {
            BlockCreativeBarrel.setLidState(world, pos, state, (Boolean)state.func_177229_b((IProperty)LID) == false);
        } else {
            IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            boolean result = false;
            if (CoFHUtils.fillHandlerWithContainer(world, handler, player, hand)) {
                result = true;
            } else if (CoFHUtils.fillContainerFromHandler(world, handler, player, hand, handler.getTankProperties()[0].getContents())) {
                result = true;
            }
            if (result) {
                ((TileEntityCreativeBarrel)te).save();
                return true;
            }
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return true;
        }
        if (side == EnumFacing.UP) {
            return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LID);
        }
        return false;
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack((Block)YeOldeTanks.blocks.creativeBarrel);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCreativeBarrel) {
            TileEntityCreativeBarrel barrel = (TileEntityCreativeBarrel)te;
            if (barrel.tank.getFluid() != null && barrel.tank.getFluidAmount() > 0) {
                stack.func_77982_d(new NBTTagCompound());
                barrel.tank.writeToNBT(stack.func_77978_p());
            }
        }
        return stack;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCreativeBarrel) {
            TileEntityCreativeBarrel barrel = (TileEntityCreativeBarrel)te;
            if (barrel.tank.getFluid() != null && barrel.tank.getFluidAmount() > 0) {
                return barrel.tank.getFluid().getFluid().getLuminosity(barrel.tank.getFluid());
            }
        }
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCreativeBarrel();
    }

    public void initItemModel() {
        YeOldeTanks.proxy.registerInvModel(this, 0, "barrel");
    }

    public Achievement getAchievement(ItemStack stack) {
        return ModAchievements.craftCreativeBarrel;
    }

    public static void setLidState(World world, BlockPos pos, IBlockState state, boolean value) {
        TileEntity originalTE = world.func_175625_s(pos);
        NBTTagCompound tag = new NBTTagCompound();
        originalTE.func_189515_b(tag);
        world.func_175656_a(pos, state.func_177226_a((IProperty)LID, (Comparable)Boolean.valueOf(value)));
        TileEntity newTE = world.func_175625_s(pos);
        newTE.func_145839_a(tag);
    }
}

