/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.yeoldetanks.entity;

import net.minecraft.entity.DataWatcher;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class EntityFluidTank
implements IFluidTank {
    public static final int AMOUNT = 16;
    public static final int TYPE = 15;
    public static final int CAPACITY = 14;
    private DataWatcher dataWatcher;

    public EntityFluidTank(DataWatcher dataWatcher) {
        this.dataWatcher = dataWatcher;
    }

    public void writeToNBT(NBTTagCompound tag) {
        FluidStack fluid = this.getFluid();
        if (fluid != null) {
            fluid.writeToNBT(tag);
        } else {
            tag.func_74778_a("Empty", "");
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (!tag.func_74764_b("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            this.setFluid(fluid);
        } else {
            this.setFluid(null);
        }
    }

    public void init(int capacity) {
        this.dataWatcher.addObject(14, (Object)capacity);
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(15, (Object)-1);
    }

    private int getFluidID() {
        return this.dataWatcher.getWatchableObjectInt(15);
    }

    private Fluid getFluidFromDataWatcher() {
        int id = this.getFluidID();
        if (id == -1) {
            return null;
        }
        return FluidRegistry.getFluid((int)id);
    }

    private void setFluidID(int id) {
        this.dataWatcher.updateObject(15, (Object)id);
    }

    private void setFluidAmount(int amount) {
        this.dataWatcher.updateObject(16, (Object)amount);
    }

    private void setCapacity(int capacity) {
        this.dataWatcher.updateObject(14, (Object)capacity);
    }

    private void setFluid(FluidStack fluid) {
        if (fluid != null) {
            this.setFluidAmount(fluid.amount);
            this.setFluidID(fluid.getFluidID());
        } else {
            this.setFluidAmount(0);
            this.setFluidID(-1);
        }
    }

    public FluidStack getFluid() {
        Fluid fluid = this.getFluidFromDataWatcher();
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, this.getFluidAmount());
    }

    public int getFluidAmount() {
        return this.dataWatcher.getWatchableObjectInt(16);
    }

    public int getCapacity() {
        return this.dataWatcher.getWatchableObjectInt(14);
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        int capacity = this.getCapacity();
        FluidStack fluid = this.getFluid();
        if (!doFill) {
            if (fluid == null) {
                return Math.min(this.getCapacity(), resource.amount);
            }
            if (!this.getFluid().isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - fluid.amount, resource.amount);
        }
        if (fluid == null) {
            FluidStack newFluid = new FluidStack(resource, Math.min(capacity, resource.amount));
            this.setFluid(newFluid);
            return newFluid.amount;
        }
        if (!fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - fluid.amount;
        if (resource.amount < filled) {
            this.setFluidAmount(fluid.amount + resource.amount);
            filled = resource.amount;
        } else {
            this.setFluidAmount(capacity);
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack fluid = this.getFluid();
        if (fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            this.setFluidAmount(fluid.amount - drained);
            if (this.getFluidAmount() <= 0) {
                this.setFluid(null);
            }
        }
        return stack;
    }
}

