/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.yeoldetanks.entity.barrelminecart;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.shadowfacts.shadowmc.fluid.EntityFluidTank;
import net.shadowfacts.yeoldetanks.CoFHUtils;
import net.shadowfacts.yeoldetanks.YOTConfig;
import net.shadowfacts.yeoldetanks.YeOldeTanks;
import net.shadowfacts.yeoldetanks.entity.ModEntities;

public class EntityBarrelMinecart
extends EntityMinecart {
    private static final DataParameter<Integer> AMOUNT = EntityDataManager.func_187226_a(EntityBarrelMinecart.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CAPACITY = EntityDataManager.func_187226_a(EntityBarrelMinecart.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityBarrelMinecart.class, (DataSerializer)DataSerializers.field_187194_d);
    public EntityFluidTank tank;

    public EntityBarrelMinecart(World world) {
        super(world);
        this.tank = new EntityFluidTank(this.field_70180_af, AMOUNT, CAPACITY, NAME, null, YOTConfig.barrelCapacity);
    }

    public EntityBarrelMinecart(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public boolean func_184230_a(EntityPlayer player, ItemStack stack, EnumHand hand) {
        return super.func_184230_a(player, stack, hand);
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, ItemStack stack, EnumHand hand) {
        if (!player.func_70093_af()) {
            if (player.func_184586_b(hand) != null && player.func_184586_b(hand).func_77973_b() == YeOldeTanks.items.dippingStick && !this.field_70170_p.field_72995_K) {
                if (this.tank.getFluid() != null) {
                    player.func_146105_b((ITextComponent)new TextComponentString("Fluid: " + this.tank.getFluid().getLocalizedName()));
                    player.func_146105_b((ITextComponent)new TextComponentString(this.tank.getFluidAmount() + "mb / " + this.tank.getCapacity() + "mb"));
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString("Empty"));
                }
                return EnumActionResult.SUCCESS;
            }
            if (!CoFHUtils.fillHandlerWithContainer(player.field_70170_p, (IFluidHandler)this.tank, player, hand)) {
                CoFHUtils.fillContainerFromHandler(player.field_70170_p, (IFluidHandler)this.tank, player, hand, this.tank.getFluid());
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.tank.writeToNBT(tag);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.tank.readFromNBT(tag);
    }

    public void func_94095_a(DamageSource damageSource) {
        super.func_94095_a(damageSource);
        ItemStack stack = new ItemStack((Block)YeOldeTanks.blocks.barrel);
        stack.func_77982_d(new NBTTagCompound());
        this.tank.writeToNBT(stack.func_77978_p());
        this.func_70099_a(stack, 0.0f);
    }

    public ItemStack getCartItem() {
        return new ItemStack((Item)YeOldeTanks.items.barrelMinecart);
    }

    public boolean func_94100_s() {
        return true;
    }

    public IBlockState func_174897_t() {
        return YeOldeTanks.blocks.barrel.func_176223_P();
    }

    public EntityMinecart.Type func_184264_v() {
        return ModEntities.TANK_CART_TYPE;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }
}

