/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.yeoldetanks.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.shadowfacts.shadowmc.achievement.AchievementProvider;
import net.shadowfacts.shadowmc.item.ItemModelProvider;
import net.shadowfacts.yeoldetanks.YeOldeTanks;
import net.shadowfacts.yeoldetanks.achievement.ModAchievements;

public class ItemInfiniteWaterBucket
extends ItemFluidContainer
implements ItemModelProvider,
AchievementProvider {
    public ItemInfiniteWaterBucket() {
        super(1000);
        this.func_77655_b("infiniteWaterBucket");
        this.setRegistryName("infiniteWaterBucket");
        this.func_77637_a(YeOldeTanks.tab);
        this.func_77625_d(1);
        FluidContainerRegistry.registerFluidContainer((Fluid)FluidRegistry.WATER, (ItemStack)new ItemStack((Item)this), (ItemStack)new ItemStack((Item)this));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            int placeZ;
            int placeY;
            RayTraceResult rayTrace = this.func_77621_a(world, player, false);
            if (rayTrace == null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            int placeX = rayTrace.func_178782_a().func_177958_n() + rayTrace.field_178784_b.func_82601_c();
            BlockPos placePos = new BlockPos(placeX, placeY = rayTrace.func_178782_a().func_177956_o() + rayTrace.field_178784_b.func_96559_d(), placeZ = rayTrace.func_178782_a().func_177952_p() + rayTrace.field_178784_b.func_82599_e());
            IBlockState placeState = world.func_180495_p(placePos);
            if (placeState.func_185904_a().func_76222_j()) {
                world.func_180501_a(placePos, Blocks.field_150358_i.func_176203_a(0), 2);
            }
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        ItemStack stack = new ItemStack((Item)this);
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound fluid = new NBTTagCompound();
        new FluidStack(FluidRegistry.WATER, 1000).writeToNBT(fluid);
        stack.func_77978_p().func_74782_a("Fluid", (NBTBase)fluid);
        list.add(stack);
    }

    @Nonnull
    public ItemStack getContainerItem(ItemStack stack) {
        return stack;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public void initItemModel() {
        YeOldeTanks.proxy.registerInvModel((Item)this, 0, "infiniteWaterBucket");
    }

    public Achievement getAchievement(ItemStack stack) {
        return ModAchievements.craftInfiniteWaterBucket;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new InfiniteFluidHandler(stack, this.capacity);
    }

    public static class InfiniteFluidHandler
    extends FluidHandlerItemStack {
        public InfiniteFluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.container.field_77994_a != 1 || maxDrain <= 0) {
                return null;
            }
            FluidStack contained = this.getFluid();
            if (contained == null || contained.amount <= 0 || !this.canDrainFluidType(contained)) {
                return null;
            }
            int drainAmount = Math.min(contained.amount, maxDrain);
            FluidStack drained = contained.copy();
            drained.amount = drainAmount;
            return drained;
        }
    }
}

