/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.book.TinkerBook;
import slimeknights.tconstruct.library.client.CustomFontRenderer;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.crosshair.CrosshairRenderEvents;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.model.ModifierModelLoader;
import slimeknights.tconstruct.library.client.model.ToolModelLoader;
import slimeknights.tconstruct.library.client.particle.EntitySlimeFx;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.shared.client.ParticleEndspeed;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackCleaver;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackFrypan;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackHammer;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackHatchet;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackLongsword;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackLumberAxe;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackRapier;

public abstract class ClientProxy
extends CommonProxy {
    public static CustomFontRenderer fontRenderer;
    protected static final ToolModelLoader loader;
    protected static final MaterialModelLoader materialLoader;
    protected static final ModifierModelLoader modifierLoader;

    public static void initClient() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)loader);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)materialLoader);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)modifierLoader);
    }

    public static void initRenderer() {
        CustomTextureCreator creator = CustomTextureCreator.INSTANCE;
        MinecraftForge.EVENT_BUS.register((Object)creator);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)creator);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)AbstractColoredTexture.CacheClearer.INSTANCE);
        fontRenderer = new CustomFontRenderer(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o);
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            fontRenderer.func_78264_a(Minecraft.func_71410_x().func_135016_M().func_135042_a() || Minecraft.func_71410_x().field_71474_y.field_151455_aw);
            fontRenderer.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)fontRenderer);
        CustomFontRenderer bookRenderer = new CustomFontRenderer(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o);
        bookRenderer.func_78264_a(true);
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            fontRenderer.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
        TinkerBook.INSTANCE.fontRenderer = bookRenderer;
        MinecraftForge.EVENT_BUS.register((Object)CrosshairRenderEvents.INSTANCE);
    }

    protected ResourceLocation registerModel(Item item, String ... customVariants) {
        return this.registerModel(item, 0, customVariants);
    }

    protected ResourceLocation registerModel(Item item, int meta, String ... customVariants) {
        ResourceLocation o = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)item);
        if (o == null) {
            TConstruct.log.error("Trying to register a model for an unregistered item: %s" + item.func_77658_a());
            return null;
        }
        ResourceLocation location = o;
        location = new ResourceLocation(location.func_110624_b(), location.func_110623_a());
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
        if (customVariants.length > 0) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        }
        for (String customVariant : customVariants) {
            String custom = location.func_110624_b() + ":" + customVariant;
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(custom)});
        }
        return location;
    }

    protected void registerItemModel(ItemStack item, String name) {
        if (!name.contains(":")) {
            name = Util.resource(name);
        }
        ModelLoader.registerItemVariants((Item)item.func_77973_b(), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        ModelLoader.setCustomModelResourceLocation((Item)item.func_77973_b(), (int)item.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    protected ResourceLocation registerToolModel(ToolCore tool) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(tool);
        if (itemLocation == null) {
            return null;
        }
        String path = "tools/" + itemLocation.func_110623_a() + ToolModelLoader.EXTENSION;
        ResourceLocation location = new ResourceLocation(itemLocation.func_110624_b(), path);
        ToolModelLoader.addPartMapping(location, tool);
        return this.registerToolModel(tool, location);
    }

    protected ResourceLocation registerToolModel(Item item, ResourceLocation location) {
        if (!location.func_110623_a().endsWith(ToolModelLoader.EXTENSION)) {
            TConstruct.log.error("The material-model " + location.toString() + " does not end with '" + ToolModelLoader.EXTENSION + "' and will therefore not be loaded by the custom model loader!");
        }
        return ClientProxy.registerIt(item, location);
    }

    public ResourceLocation registerMaterialItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return this.registerMaterialModel(item, new ResourceLocation(itemLocation.func_110624_b(), itemLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
    }

    public ResourceLocation registerMaterialModel(Item item, ResourceLocation location) {
        if (!location.func_110623_a().endsWith(MaterialModelLoader.EXTENSION)) {
            TConstruct.log.error("The material-model " + location.toString() + " does not end with '" + MaterialModelLoader.EXTENSION + "' and will therefore not be loaded by the custom model loader!");
        }
        return ClientProxy.registerIt(item, location);
    }

    public void registerModifierModel(IModifier modifier, ResourceLocation location) {
        modifierLoader.registerModifierFile(modifier.getIdentifier(), location);
    }

    public ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return ClientProxy.registerIt(item, itemLocation);
    }

    public ResourceLocation registerItemModel(Block block) {
        return this.registerItemModel(Item.func_150898_a((Block)block));
    }

    public void registerItemModel(Item item, int meta, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    private static ResourceLocation registerIt(Item item, final ResourceLocation location) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            @Nonnull
            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                return new ModelResourceLocation(location, "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        return location;
    }

    protected void registerItemBlockMeta(Block block) {
        if (block != null) {
            ((ItemBlockMeta)Item.func_150898_a((Block)block)).registerItemModels();
        }
    }

    public static ResourceLocation getItemLocation(Item item) {
        return Util.getItemLocation(item);
    }

    @Override
    public void sendPacketToServerOnly(AbstractPacket packet) {
        TinkerNetwork.sendToServer(packet);
    }

    @Override
    public void spawnParticle(Particles particleType, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... data) {
        if (world == null) {
            world = Minecraft.func_71410_x().field_71441_e;
        }
        Particle effect = ClientProxy.createParticle(particleType, world, x, y, z, xSpeed, ySpeed, zSpeed, data);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(effect);
        if (particleType == Particles.EFFECT && data[0] > 1) {
            for (int i = 0; i < data[0] - 1; ++i) {
                effect = ClientProxy.createParticle(particleType, world, x, y, z, xSpeed, ySpeed, zSpeed, data);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(effect);
            }
        }
    }

    @Override
    public void spawnSlimeParticle(World world, double x, double y, double z) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new EntitySlimeFx(world, x, y, z, TinkerCommons.matSlimeBallBlue.func_77973_b(), TinkerCommons.matSlimeBallBlue.func_77952_i()));
    }

    public static Particle createParticle(Particles type, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... data) {
        switch (type) {
            case BLUE_SLIME: {
                return new EntitySlimeFx(world, x, y, z, TinkerCommons.matSlimeBallBlue.func_77973_b(), TinkerCommons.matSlimeBallBlue.func_77952_i());
            }
            case CLEAVER_ATTACK: {
                return new ParticleAttackCleaver(world, x, y, z, xSpeed, ySpeed, zSpeed, Minecraft.func_71410_x().func_110434_K());
            }
            case LONGSWORD_ATTACK: {
                return new ParticleAttackLongsword(world, x, y, z, xSpeed, ySpeed, zSpeed, Minecraft.func_71410_x().func_110434_K());
            }
            case RAPIER_ATTACK: {
                return new ParticleAttackRapier(world, x, y, z, xSpeed, ySpeed, zSpeed, Minecraft.func_71410_x().func_110434_K());
            }
            case HATCHET_ATTACK: {
                return new ParticleAttackHatchet(world, x, y, z, xSpeed, ySpeed, zSpeed, Minecraft.func_71410_x().func_110434_K());
            }
            case LUMBERAXE_ATTACK: {
                return new ParticleAttackLumberAxe(world, x, y, z, xSpeed, ySpeed, zSpeed, Minecraft.func_71410_x().func_110434_K());
            }
            case FRYPAN_ATTACK: {
                return new ParticleAttackFrypan(world, x, y, z, xSpeed, ySpeed, zSpeed, Minecraft.func_71410_x().func_110434_K());
            }
            case HAMMER_ATTACK: {
                return new ParticleAttackHammer(world, x, y, z, xSpeed, ySpeed, zSpeed, Minecraft.func_71410_x().func_110434_K());
            }
            case EFFECT: {
                return new ParticleEffect(data[1], world, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            case ENDSPEED: {
                return new ParticleEndspeed(world, x, y, z, xSpeed, ySpeed, zSpeed);
            }
        }
        return null;
    }

    @Override
    public void preventPlayerSlowdown(Entity player, float originalSpeed, Item item) {
        if (player instanceof EntityPlayerSP) {
            EntityPlayerSP playerSP = (EntityPlayerSP)player;
            ItemStack usingItem = playerSP.field_71071_by.func_70448_g();
            if (usingItem != null && usingItem.func_77973_b() == item) {
                playerSP.field_71158_b.field_78900_b *= originalSpeed * 5.0f;
                playerSP.field_71158_b.field_78902_a *= originalSpeed * 5.0f;
            }
        }
    }

    @Override
    public void customExplosion(World world, Explosion explosion) {
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            // empty if block
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
    }

    public <T extends Item> ResourceLocation registerPartModel(T item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        String path = "parts/" + itemLocation.func_110623_a() + MaterialModelLoader.EXTENSION;
        ResourceLocation location = new ResourceLocation(itemLocation.func_110624_b(), path);
        MaterialModelLoader.addPartMapping(location, (IToolPart)item);
        return this.registerMaterialModel(item, location);
    }

    @Override
    public void updateEquippedItemForRendering(EnumHand hand) {
        Minecraft.func_71410_x().func_175597_ag().func_187460_a(hand);
        Minecraft.func_71410_x().func_175597_ag().func_78441_a();
    }

    static {
        loader = new ToolModelLoader();
        materialLoader = new MaterialModelLoader();
        modifierLoader = new ModifierModelLoader();
    }

    public static class PatternMeshDefinition
    implements ItemMeshDefinition {
        private final ResourceLocation baseLocation;

        public PatternMeshDefinition(ResourceLocation baseLocation) {
            this.baseLocation = baseLocation;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            Item item = Pattern.getPartFromTag(stack);
            String suffix = "";
            if (item != null) {
                suffix = Pattern.getTextureIdentifier(item);
            }
            return new ModelResourceLocation(new ResourceLocation(this.baseLocation.func_110624_b(), this.baseLocation.func_110623_a() + suffix), "inventory");
        }
    }
}

