/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.network.SpawnParticlePacket;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.shared.client.ParticleEffect;

public class CommonProxy {
    public void preInit() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            TConstruct.log.error("Proxy.preInit has to be called during Pre-Initialisation.");
        }
        this.registerModels();
    }

    public void init() {
        if (!Loader.instance().isInState(LoaderState.INITIALIZATION)) {
            TConstruct.log.error("Proxy.init has to be called during Initialisation.");
        }
    }

    public void postInit() {
        if (!Loader.instance().isInState(LoaderState.POSTINITIALIZATION)) {
            TConstruct.log.error("Proxy.postInit has to be called during Post-Initialisation.");
        }
    }

    protected void registerModels() {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            TConstruct.log.error("Proxy.registerModels has to be called during preInit. Otherwise the models wont be found on first load.");
        }
    }

    public void sendPacketToServerOnly(AbstractPacket packet) {
    }

    public void spawnAttackParticle(Particles particleType, Entity entity, double height) {
        float distance = (float)Math.PI / 180;
        double xd = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        double zd = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        double yd = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        distance = 1.0f;
        this.spawnParticle(particleType, entity.field_70170_p, entity.field_70165_t + (xd *= (double)distance), entity.field_70163_u + (double)entity.field_70131_O * height, entity.field_70161_v + (zd *= (double)distance), xd, yd *= (double)distance, zd, new int[0]);
    }

    public void spawnEffectParticle(ParticleEffect.Type type, EntityLivingBase entity, int count) {
        this.spawnParticle(Particles.EFFECT, entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O * 0.5f), entity.field_70161_v, 0.0, 1.0, 0.0, count, type.ordinal());
    }

    public void spawnEffectParticle(ParticleEffect.Type type, World world, double x, double y, double z, int count) {
        this.spawnParticle(Particles.EFFECT, world, x, y, z, 0.0, -1.0, 0.0, count, type.ordinal());
    }

    public void spawnParticle(Particles particleType, World world, double x, double y, double z, int ... data) {
        this.spawnParticle(particleType, world, x, y, z, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particles particleType, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... data) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 32.0);
        SpawnParticlePacket packet = new SpawnParticlePacket(particleType, x, y, z, xSpeed, ySpeed, zSpeed, data);
        TinkerNetwork.sendToAllAround((AbstractPacket)packet, point);
    }

    public void spawnSlimeParticle(World world, double x, double y, double z) {
    }

    public void registerFluidModels(Fluid fluid) {
    }

    public void preventPlayerSlowdown(Entity player, float originalSpeed, Item item) {
    }

    public void customExplosion(World world, Explosion explosion) {
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            return;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (!explosion.field_82755_b) {
            explosion.func_180342_d();
        }
    }

    public void updateEquippedItemForRendering(EnumHand hand) {
    }
}

