/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;
import slimeknights.tconstruct.world.TinkerWorld;

@Pulse(id="TinkerOredict", forced=true)
public class TinkerOredict {
    public static final String PulseId = "TinkerOredict";
    public static final String[] dyes = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};

    @Subscribe
    public static void doTheOredict(FMLPreInitializationEvent event) {
        TinkerOredict.ensureOredict();
        TinkerOredict.registerCommon();
        TinkerOredict.registerTools();
        TinkerOredict.registerSmeltery();
        TinkerOredict.registerWorld();
        TinkerOredict.registerGadgets();
    }

    private static void ensureOredict() {
        TinkerOredict.oredict(Blocks.field_150462_ai, "workbench");
        TinkerOredict.oredict((Block)Blocks.field_150434_aF, "blockCactus");
        TinkerOredict.oredict(Blocks.field_180399_cE, "blockSlime");
        TinkerOredict.oredict(Blocks.field_150343_Z, "obsidian");
        TinkerOredict.oredict(Blocks.field_150424_aL, "netherrack");
        TinkerOredict.oredict(Blocks.field_180397_cI, "prismarine");
        TinkerOredict.oredict(Blocks.field_150395_bd, "vine");
        TinkerOredict.oredict(Blocks.field_150346_d, "dirt");
        TinkerOredict.oredict(Blocks.field_150341_Y, "blockMossy");
        TinkerOredict.oredict(new ItemStack(Blocks.field_150417_aV, 1, BlockStoneBrick.field_176250_M), "blockMossy");
        TinkerOredict.oredict(Blocks.field_150415_aT, "trapdoorWood");
    }

    private static void registerCommon() {
        String dict = "slimeball";
        TinkerOredict.oredict(Items.field_151123_aH, dict + "Green");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallBlue, dict, dict + "Blue");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallPurple, dict, dict + "Purple");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallBlood, dict, dict + "Blood");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallMagma, dict, dict + "Magma");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetCobalt, TinkerCommons.ingotCobalt, TinkerCommons.blockCobalt, "Cobalt");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetArdite, TinkerCommons.ingotArdite, TinkerCommons.blockArdite, "Ardite");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetManyullyn, TinkerCommons.ingotManyullyn, TinkerCommons.blockManyullyn, "Manyullyn");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetKnightSlime, TinkerCommons.ingotKnightSlime, TinkerCommons.blockKnightSlime, "Knightslime");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetPigIron, TinkerCommons.ingotPigIron, TinkerCommons.blockPigIron, "Pigiron");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetAlubrass, TinkerCommons.ingotAlubrass, TinkerCommons.blockAlubrass, "Alubrass");
        String metal = "blockMetal";
        TinkerOredict.oredict(new ItemStack(Blocks.field_150339_S), metal);
        TinkerOredict.oredict(new ItemStack(Blocks.field_150340_R), metal);
        TinkerOredict.oredict(TinkerCommons.searedBrick, "ingotBrickSeared");
        dict = "slimecrystal";
        TinkerOredict.oredict(TinkerCommons.matSlimeCrystalGreen, dict, dict + "Green");
        TinkerOredict.oredict(TinkerCommons.matSlimeCrystalBlue, dict, dict + "Blue");
        TinkerOredict.oredict(TinkerCommons.matSlimeCrystalMagma, dict, dict + "Magma");
        TinkerOredict.oredict(TinkerCommons.oreCobalt, "oreCobalt");
        TinkerOredict.oredict(TinkerCommons.oreArdite, "oreArdite");
        TinkerOredict.oredict(TinkerCommons.blockClearGlass, "blockGlass");
        TinkerOredict.oredict(TinkerCommons.blockClearStainedGlass, "blockGlass");
        for (int i = 0; i > 16; ++i) {
            TinkerOredict.oredict(TinkerCommons.blockClearStainedGlass, i, "blockGlass" + dyes[i]);
        }
    }

    private static void oredictNIB(ItemStack nugget, ItemStack ingot, ItemStack block, String oreSuffix) {
        TinkerOredict.oredict(nugget, "nugget" + oreSuffix);
        TinkerOredict.oredict(ingot, "ingot" + oreSuffix);
        TinkerOredict.oredict(block, "block" + oreSuffix);
    }

    private static void registerTools() {
        TinkerOredict.oredict((Block)TinkerTools.toolTables, BlockToolTable.TableTypes.CraftingStation.meta, "workbench");
        TinkerOredict.oredict((Item)TinkerTools.pickHead, "partPickHead");
        TinkerOredict.oredict((Item)TinkerTools.binding, "partBinding");
        TinkerOredict.oredict((Item)TinkerTools.toolRod, "partToolRod");
        TinkerOredict.oredict((Item)TinkerTools.pattern, "pattern");
    }

    private static void registerSmeltery() {
        TinkerOredict.oredict((Item)TinkerSmeltery.cast, "cast");
        TinkerOredict.oredict((Block)TinkerSmeltery.searedBlock, Short.MAX_VALUE, "blockSeared");
    }

    private static void registerWorld() {
        TinkerOredict.oredict((Block)TinkerWorld.slimeSapling, "treeSapling");
        TinkerOredict.oredict((Block)TinkerCommons.blockSlime, "blockSlime");
        TinkerOredict.oredict((Block)TinkerCommons.blockSlimeCongealed, "blockSlimeCongealed");
        TinkerOredict.oredict((Block)TinkerWorld.slimeDirt, "blockSlimeDirt");
        TinkerOredict.oredict((Block)TinkerWorld.slimeGrass, "blockSlimeGrass");
        TinkerOredict.oredict((Block)TinkerWorld.slimeLeaves, "treeLeaves");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue1, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue2, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue3, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple1, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple2, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple3, "vine");
    }

    private static void registerGadgets() {
        TinkerOredict.oredict(TinkerGadgets.stoneStick, "rodStone");
        TinkerOredict.oredict(TinkerGadgets.stoneTorch, "torch");
    }

    public static void oredict(Item item, String ... name) {
        TinkerOredict.oredict(item, Short.MAX_VALUE, name);
    }

    public static void oredict(Block block, String ... name) {
        TinkerOredict.oredict(block, Short.MAX_VALUE, name);
    }

    public static void oredict(Item item, int meta, String ... name) {
        TinkerOredict.oredict(new ItemStack(item, 1, meta), name);
    }

    public static void oredict(Block block, int meta, String ... name) {
        TinkerOredict.oredict(new ItemStack(block, 1, meta), name);
    }

    public static void oredict(ItemStack stack, String ... names) {
        if (stack != null && stack.func_77973_b() != null) {
            for (String name : names) {
                OreDictionary.registerOre((String)name, (ItemStack)stack);
            }
        }
    }
}

