/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.tools.TinkerTools;

public class SpawnParticlePacket
extends AbstractPacketThreadsafe {
    public Particles particle;
    double x;
    double y;
    double z;
    double xSpeed;
    double ySpeed;
    double zSpeed;
    int[] data;

    public SpawnParticlePacket() {
    }

    public SpawnParticlePacket(Particles particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... data) {
        this.particle = particle;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
        this.data = data;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        TinkerTools.proxy.spawnParticle(this.particle, null, this.x, this.y, this.z, this.xSpeed, this.ySpeed, this.zSpeed, this.data);
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Clientside only");
    }

    public void fromBytes(ByteBuf buf) {
        this.particle = Particles.values()[buf.readInt()];
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.xSpeed = buf.readDouble();
        this.ySpeed = buf.readDouble();
        this.zSpeed = buf.readDouble();
        this.data = new int[buf.readInt()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.particle.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.xSpeed);
        buf.writeDouble(this.ySpeed);
        buf.writeDouble(this.zSpeed);
        buf.writeInt(this.data.length);
        for (int i : this.data) {
            buf.writeInt(i);
        }
    }
}

