/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.CreativeTab;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.DryingRecipe;
import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IPattern;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Shard;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;

public final class TinkerRegistry {
    public static final Logger log = Util.getLogger("API");
    public static CreativeTab tabGeneral = new CreativeTab("TinkerGeneral", new ItemStack(Items.field_151123_aH));
    public static CreativeTab tabTools = new CreativeTab("TinkerTools", new ItemStack(Items.field_151035_b));
    public static CreativeTab tabParts = new CreativeTab("TinkerToolParts", new ItemStack(Items.field_151055_y));
    public static CreativeTab tabSmeltery = new CreativeTab("TinkerSmeltery", new ItemStack(Item.func_150898_a((Block)Blocks.field_150417_aV)));
    public static CreativeTab tabWorld = new CreativeTab("TinkerWorld", new ItemStack(Item.func_150898_a((Block)Blocks.field_180399_cE)));
    public static CreativeTab tabGadgets = new CreativeTab("TinkerGadgets", new ItemStack(Blocks.field_150335_W));
    private static final Map<String, Material> materials = Maps.newLinkedHashMap();
    private static final Map<String, ITrait> traits = new THashMap();
    private static final Map<String, String> materialRegisteredByMod = new THashMap();
    private static final Map<String, Map<String, String>> statRegisteredByMod = new THashMap();
    private static final Map<String, Map<String, String>> traitRegisteredByMod = new THashMap();
    private static final Set<String> cancelledMaterials = new THashSet();
    private static final Set<ToolCore> tools = new TLinkedHashSet();
    private static final Set<IToolPart> toolParts = new TLinkedHashSet();
    private static final Set<ToolCore> toolStationCrafting = Sets.newLinkedHashSet();
    private static final Set<ToolCore> toolForgeCrafting = Sets.newLinkedHashSet();
    private static final List<ItemStack> stencilTableCrafting = Lists.newLinkedList();
    private static final Set<Item> patternItems = Sets.newHashSet();
    private static final Set<Item> castItems = Sets.newHashSet();
    private static Shard shardItem;
    private static final Map<String, IModifier> modifiers;
    private static List<MeltingRecipe> meltingRegistry;
    private static List<ICastingRecipe> tableCastRegistry;
    private static List<ICastingRecipe> basinCastRegistry;
    private static List<AlloyRecipe> alloyRegistry;
    private static Map<FluidStack, Integer> smelteryFuels;
    private static Map<String, FluidStack> entityMeltingRegistry;
    private static List<DryingRecipe> dryingRegistry;

    private TinkerRegistry() {
    }

    public static void addMaterial(Material material, IMaterialStats stats, ITrait trait) {
        TinkerRegistry.addMaterial(material, stats);
        TinkerRegistry.addMaterialTrait(material.identifier, trait, null);
    }

    public static void addMaterial(Material material, ITrait trait) {
        TinkerRegistry.addMaterial(material);
        TinkerRegistry.addMaterialTrait(material.identifier, trait, null);
    }

    public static void addMaterial(Material material, IMaterialStats stats) {
        TinkerRegistry.addMaterial(material);
        TinkerRegistry.addMaterialStats(material.identifier, stats);
    }

    public static void addMaterial(Material material) {
        if (CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)material.getIdentifier())) {
            TinkerRegistry.error("Could not register Material \"%s\": Material identifier must not contain any spaces.", material.identifier);
            return;
        }
        if (CharMatcher.JAVA_UPPER_CASE.matchesAnyOf((CharSequence)material.getIdentifier())) {
            TinkerRegistry.error("Could not register Material \"%s\": Material identifier must be completely lowercase.", material.identifier);
            return;
        }
        if (materials.containsKey(material.identifier)) {
            String registeredBy = materialRegisteredByMod.get(material.identifier);
            TinkerRegistry.error(String.format("Could not register Material \"%s\": It was already registered by %s", material.identifier, registeredBy), new Object[0]);
            return;
        }
        MaterialEvent.MaterialRegisterEvent event = new MaterialEvent.MaterialRegisterEvent(material);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            log.trace("Addition of material {} cancelled by event", new Object[]{material.getIdentifier()});
            cancelledMaterials.add(material.getIdentifier());
            return;
        }
        materials.put(material.identifier, material);
        TinkerRegistry.putMaterialTrace(material.identifier);
    }

    public static Material getMaterial(String identifier) {
        return materials.containsKey(identifier) ? materials.get(identifier) : Material.UNKNOWN;
    }

    public static Collection<Material> getAllMaterials() {
        return ImmutableList.copyOf(materials.values());
    }

    public static Collection<Material> getAllMaterialsWithStats(String statType) {
        ImmutableList.Builder mats = ImmutableList.builder();
        for (Material material : materials.values()) {
            if (!material.hasStats(statType)) continue;
            mats.add((Object)material);
        }
        return mats.build();
    }

    public static void addTrait(ITrait trait) {
        if (traits.containsKey(trait.getIdentifier())) {
            return;
        }
        traits.put(trait.getIdentifier(), trait);
        String activeMod = Loader.instance().activeModContainer().getModId();
        TinkerRegistry.putTraitTrace(trait.getIdentifier(), trait, activeMod);
    }

    public static void addMaterialStats(String materialIdentifier, IMaterialStats stats) {
        if (cancelledMaterials.contains(materialIdentifier)) {
            return;
        }
        if (!materials.containsKey(materialIdentifier)) {
            TinkerRegistry.error(String.format("Could not add Stats \"%s\" to \"%s\": Unknown Material", stats.getIdentifier(), materialIdentifier), new Object[0]);
            return;
        }
        Material material = materials.get(materialIdentifier);
        TinkerRegistry.addMaterialStats(material, stats);
    }

    public static void addMaterialStats(Material material, IMaterialStats stats, IMaterialStats ... stats2) {
        TinkerRegistry.addMaterialStats(material, stats);
        for (IMaterialStats stat : stats2) {
            TinkerRegistry.addMaterialStats(material, stat);
        }
    }

    public static void addMaterialStats(Material material, IMaterialStats stats) {
        if (material == null) {
            TinkerRegistry.error(String.format("Could not add Stats \"%s\": Material is null", stats.getIdentifier()), new Object[0]);
            return;
        }
        if (cancelledMaterials.contains(material.identifier)) {
            return;
        }
        String identifier = material.identifier;
        if (material.getStats(stats.getIdentifier()) != null) {
            String registeredBy = "Unknown";
            Map<String, String> matReg = statRegisteredByMod.get(identifier);
            if (matReg != null) {
                registeredBy = matReg.get(stats.getIdentifier());
            }
            TinkerRegistry.error(String.format("Could not add Stats to \"%s\": Stats of type \"%s\" were already registered by %s. Use the events to modify stats.", identifier, stats.getIdentifier(), registeredBy), new Object[0]);
            return;
        }
        if (Material.UNKNOWN.getStats(stats.getIdentifier()) == null) {
            TinkerRegistry.error("Could not add Stat of type \"%s\": Default Material does not have default stats for said type. Please add default-values to the default material \"unknown\" first.", stats.getIdentifier());
            return;
        }
        MaterialEvent.StatRegisterEvent<IMaterialStats> event = new MaterialEvent.StatRegisterEvent<IMaterialStats>(material, stats);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.getResult() == Event.Result.ALLOW) {
            stats = event.newStats;
        }
        material.addStats(stats);
        String activeMod = Loader.instance().activeModContainer().getModId();
        TinkerRegistry.putStatTrace(identifier, stats, activeMod);
    }

    public static void addMaterialTrait(String materialIdentifier, ITrait trait, String stats) {
        if (cancelledMaterials.contains(materialIdentifier)) {
            return;
        }
        if (!materials.containsKey(materialIdentifier)) {
            TinkerRegistry.error(String.format("Could not add Trait \"%s\" to \"%s\": Unknown Material", trait.getIdentifier(), materialIdentifier), new Object[0]);
            return;
        }
        Material material = materials.get(materialIdentifier);
        TinkerRegistry.addMaterialTrait(material, trait, stats);
    }

    public static void addMaterialTrait(Material material, ITrait trait, String stats) {
        if (TinkerRegistry.checkMaterialTrait(material, trait, stats)) {
            material.addTrait(trait);
        }
    }

    public static boolean checkMaterialTrait(Material material, ITrait trait, String stats) {
        if (material == null) {
            TinkerRegistry.error(String.format("Could not add Trait \"%s\": Material is null", trait.getIdentifier()), new Object[0]);
            return false;
        }
        if (cancelledMaterials.contains(material.identifier)) {
            return false;
        }
        String identifier = material.identifier;
        if (material.hasTrait(trait.getIdentifier(), stats)) {
            String registeredBy = "Unknown";
            Map<String, String> matReg = traitRegisteredByMod.get(identifier);
            if (matReg != null) {
                registeredBy = matReg.get(trait.getIdentifier());
            }
            TinkerRegistry.error(String.format("Could not add Trait to \"%s\": Trait \"%s\" was already registered by %s", identifier, trait.getIdentifier(), registeredBy), new Object[0]);
            return false;
        }
        MaterialEvent.TraitRegisterEvent<ITrait> event = new MaterialEvent.TraitRegisterEvent<ITrait>(material, trait);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            log.trace("Trait {} on {} cancelled by event", new Object[]{trait.getIdentifier(), material.getIdentifier()});
            return false;
        }
        TinkerRegistry.addTrait(trait);
        return true;
    }

    public static ITrait getTrait(String identifier) {
        return traits.get(identifier);
    }

    public static void registerTool(ToolCore tool) {
        tools.add(tool);
        for (PartMaterialType pmt : tool.getRequiredComponents()) {
            for (IToolPart tp : pmt.getPossibleParts()) {
                TinkerRegistry.registerToolPart(tp);
            }
        }
    }

    public static Set<ToolCore> getTools() {
        return ImmutableSet.copyOf(tools);
    }

    public static void registerToolPart(IToolPart part) {
        toolParts.add(part);
        if (part instanceof Item) {
            TinkerRegistry.addPatternForItem((Item)part);
            TinkerRegistry.addCastForItem((Item)part);
        }
    }

    public static Set<IToolPart> getToolParts() {
        return ImmutableSet.copyOf(toolParts);
    }

    public static void registerToolCrafting(ToolCore tool) {
        TinkerRegistry.registerToolStationCrafting(tool);
        TinkerRegistry.registerToolForgeCrafting(tool);
    }

    public static void registerToolStationCrafting(ToolCore tool) {
        toolStationCrafting.add(tool);
    }

    public static Set<ToolCore> getToolStationCrafting() {
        return ImmutableSet.copyOf(toolStationCrafting);
    }

    public static void registerToolForgeCrafting(ToolCore tool) {
        toolForgeCrafting.add(tool);
    }

    public static Set<ToolCore> getToolForgeCrafting() {
        return ImmutableSet.copyOf(toolForgeCrafting);
    }

    public static void registerStencilTableCrafting(ItemStack stencil) {
        if (!(stencil.func_77973_b() instanceof IPattern)) {
            TinkerRegistry.error(String.format("Stencil Table Crafting has to be a pattern (%s)", stencil.toString()), new Object[0]);
            return;
        }
        stencilTableCrafting.add(stencil);
    }

    public static List<ItemStack> getStencilTableCrafting() {
        return ImmutableList.copyOf(stencilTableCrafting);
    }

    public static void setShardItem(Shard shard) {
        if (shard == null) {
            return;
        }
        shardItem = shard;
    }

    public static Shard getShard() {
        return shardItem;
    }

    public static ItemStack getShard(Material material) {
        ItemStack out = material.getShard();
        if (out == null) {
            out = shardItem.getItemstackWithMaterial(material);
        }
        return out;
    }

    public static void addPatternForItem(Item item) {
        patternItems.add(item);
    }

    public static void addCastForItem(Item item) {
        castItems.add(item);
    }

    public static Collection<Item> getPatternItems() {
        return ImmutableList.copyOf(patternItems);
    }

    public static Collection<Item> getCastItems() {
        return ImmutableList.copyOf(castItems);
    }

    public static void registerModifier(IModifier modifier) {
        modifiers.put(modifier.getIdentifier(), modifier);
    }

    public static void registerModifierAlias(IModifier modifier, String alias) {
        modifiers.put(alias, modifier);
    }

    public static IModifier getModifier(String identifier) {
        return modifiers.get(identifier);
    }

    public static Collection<IModifier> getAllModifiers() {
        return ImmutableList.copyOf(modifiers.values());
    }

    public static void registerMelting(Item item, Fluid fluid, int amount) {
        ItemStack stack = new ItemStack(item, 1, Short.MAX_VALUE);
        TinkerRegistry.registerMelting(new MeltingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1, amount), fluid));
    }

    public static void registerMelting(Block block, Fluid fluid, int amount) {
        ItemStack stack = new ItemStack(block, 1, Short.MAX_VALUE);
        TinkerRegistry.registerMelting(new MeltingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1, amount), fluid));
    }

    public static void registerMelting(ItemStack stack, Fluid fluid, int amount) {
        TinkerRegistry.registerMelting(new MeltingRecipe((RecipeMatch)new RecipeMatch.ItemCombination(amount, new ItemStack[]{stack}), fluid));
    }

    public static void registerMelting(String oredict, Fluid fluid, int amount) {
        TinkerRegistry.registerMelting(new MeltingRecipe((RecipeMatch)new RecipeMatch.Oredict(oredict, 1, amount), fluid));
    }

    public static void registerMelting(MeltingRecipe recipe) {
        if (new TinkerRegisterEvent.MestingRegisterEvent(recipe).fire()) {
            meltingRegistry.add(recipe);
        }
    }

    public static MeltingRecipe getMelting(ItemStack stack) {
        for (MeltingRecipe recipe : meltingRegistry) {
            if (!recipe.matches(stack)) continue;
            return recipe;
        }
        return null;
    }

    public static List<MeltingRecipe> getAllMeltingRecipies() {
        return ImmutableList.copyOf(meltingRegistry);
    }

    public static void registerAlloy(FluidStack result, FluidStack ... inputs) {
        if (result.amount < 1) {
            TinkerRegistry.error("Alloy Recipe: Resulting alloy %s has to have an amount (%d)", result.getLocalizedName(), result.amount);
        }
        if (inputs.length < 2) {
            TinkerRegistry.error("Alloy Recipe: Alloy for %s must consist of at least 2 liquids", result.getLocalizedName());
        }
        TinkerRegistry.registerAlloy(new AlloyRecipe(result, inputs));
    }

    public static void registerAlloy(AlloyRecipe recipe) {
        if (new TinkerRegisterEvent.AlloyRegisterEvent(recipe).fire()) {
            alloyRegistry.add(recipe);
        }
    }

    public static List<AlloyRecipe> getAlloys() {
        return ImmutableList.copyOf(alloyRegistry);
    }

    public static void registerTableCasting(ItemStack output, @Nullable ItemStack cast, Fluid fluid, int amount) {
        RecipeMatch rm = null;
        if (cast != null) {
            rm = RecipeMatch.ofNBT((ItemStack)cast);
        }
        TinkerRegistry.registerTableCasting(new CastingRecipe(output, rm, fluid, amount));
    }

    public static void registerTableCasting(ICastingRecipe recipe) {
        if (new TinkerRegisterEvent.TableCastingRegisterEvent(recipe).fire()) {
            tableCastRegistry.add(recipe);
        }
    }

    public static ICastingRecipe getTableCasting(@Nullable ItemStack cast, Fluid fluid) {
        for (ICastingRecipe recipe : tableCastRegistry) {
            if (!recipe.matches(cast, fluid)) continue;
            return recipe;
        }
        return null;
    }

    public static List<ICastingRecipe> getAllTableCastingRecipes() {
        return ImmutableList.copyOf(tableCastRegistry);
    }

    public static void registerBasinCasting(ItemStack output, @Nullable ItemStack cast, Fluid fluid, int amount) {
        RecipeMatch rm = null;
        if (cast != null) {
            rm = RecipeMatch.ofNBT((ItemStack)cast);
        }
        TinkerRegistry.registerBasinCasting(new CastingRecipe(output, rm, fluid, amount));
    }

    public static void registerBasinCasting(ICastingRecipe recipe) {
        if (new TinkerRegisterEvent.BasinCastingRegisterEvent(recipe).fire()) {
            basinCastRegistry.add(recipe);
        }
    }

    public static ICastingRecipe getBasinCasting(@Nullable ItemStack cast, Fluid fluid) {
        for (ICastingRecipe recipe : basinCastRegistry) {
            if (!recipe.matches(cast, fluid)) continue;
            return recipe;
        }
        return null;
    }

    public static List<ICastingRecipe> getAllBasinCastingRecipes() {
        return ImmutableList.copyOf(basinCastRegistry);
    }

    public static void registerSmelteryFuel(FluidStack fluidStack, int fuelDuration) {
        smelteryFuels.put(fluidStack, fuelDuration);
    }

    public static boolean isSmelteryFuel(FluidStack in) {
        for (Map.Entry<FluidStack, Integer> entry : smelteryFuels.entrySet()) {
            if (!entry.getKey().isFluidEqual(in)) continue;
            return true;
        }
        return false;
    }

    public static int consumeSmelteryFuel(FluidStack in) {
        for (Map.Entry<FluidStack, Integer> entry : smelteryFuels.entrySet()) {
            if (!entry.getKey().isFluidEqual(in)) continue;
            FluidStack fuel = entry.getKey();
            int out = entry.getValue();
            if (in.amount < fuel.amount) {
                float coeff = (float)in.amount / (float)fuel.amount;
                out = Math.round(coeff * (float)in.amount);
                in.amount = 0;
            } else {
                in.amount -= fuel.amount;
            }
            return out;
        }
        return 0;
    }

    public static Collection<FluidStack> getSmelteryFuels() {
        return ImmutableSet.copyOf(smelteryFuels.keySet());
    }

    public static void registerEntityMelting(Class<? extends Entity> clazz, FluidStack liquid) {
        TinkerRegisterEvent.EntityMeltingRegisterEvent event;
        String name = (String)EntityList.field_75626_c.get(clazz);
        if (name == null) {
            TinkerRegistry.error("Entity Melting: Entity %s is not registered in the EntityList", clazz.getSimpleName());
        }
        if ((event = new TinkerRegisterEvent.EntityMeltingRegisterEvent(clazz, liquid)).fire()) {
            entityMeltingRegistry.put(name, event.getNewFluidStack());
        }
    }

    public static FluidStack getMeltingForEntity(Entity entity) {
        String name = EntityList.func_75621_b((Entity)entity);
        return entityMeltingRegistry.get(name);
    }

    public static List<DryingRecipe> getAllDryingRecipes() {
        return ImmutableList.copyOf(dryingRegistry);
    }

    public static void registerDryingRecipe(ItemStack input, ItemStack output, int time) {
        if (output == null || input == null) {
            return;
        }
        TinkerRegistry.addDryingReciye(new DryingRecipe((RecipeMatch)new RecipeMatch.Item(input, 1), output, time));
    }

    public static void registerDryingRecipe(Item input, ItemStack output, int time) {
        if (output == null || input == null) {
            return;
        }
        ItemStack stack = new ItemStack(input, 1, Short.MAX_VALUE);
        TinkerRegistry.addDryingReciye(new DryingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1), output, time));
    }

    public static void registerDryingRecipe(Item input, Item output, int time) {
        if (output == null || input == null) {
            return;
        }
        ItemStack stack = new ItemStack(input, 1, Short.MAX_VALUE);
        TinkerRegistry.addDryingReciye(new DryingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1), new ItemStack(output), time));
    }

    public static void registerDryingRecipe(Block input, Block output, int time) {
        if (output == null || input == null) {
            return;
        }
        ItemStack stack = new ItemStack(input, 1, Short.MAX_VALUE);
        TinkerRegistry.addDryingReciye(new DryingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1), new ItemStack(output), time));
    }

    public static void registerDryingRecipe(String oredict, ItemStack output, int time) {
        if (output == null || oredict == null) {
            return;
        }
        TinkerRegistry.addDryingReciye(new DryingRecipe((RecipeMatch)new RecipeMatch.Oredict(oredict, 1), output, time));
    }

    private static void addDryingReciye(DryingRecipe dryingRecipe) {
        if (new TinkerRegisterEvent.DryingRackRegisterEvent(dryingRecipe).fire()) {
            dryingRegistry.add(dryingRecipe);
        }
    }

    public static int getDryingTime(ItemStack input) {
        for (DryingRecipe r : dryingRegistry) {
            if (!r.matches(input)) continue;
            return r.getTime();
        }
        return -1;
    }

    public static ItemStack getDryingResult(ItemStack input) {
        for (DryingRecipe r : dryingRegistry) {
            if (!r.matches(input)) continue;
            return r.getResult();
        }
        return null;
    }

    static void putMaterialTrace(String materialIdentifier) {
        String activeMod = Loader.instance().activeModContainer().getName();
        materialRegisteredByMod.put(materialIdentifier, activeMod);
    }

    static void putStatTrace(String materialIdentifier, IMaterialStats stats, String trace) {
        if (!statRegisteredByMod.containsKey(materialIdentifier)) {
            statRegisteredByMod.put(materialIdentifier, new HashMap());
        }
        statRegisteredByMod.get(materialIdentifier).put(stats.getIdentifier(), trace);
    }

    static void putTraitTrace(String materialIdentifier, ITrait trait, String trace) {
        if (!traitRegisteredByMod.containsKey(materialIdentifier)) {
            traitRegisteredByMod.put(materialIdentifier, new HashMap());
        }
        traitRegisteredByMod.get(materialIdentifier).put(trait.getIdentifier(), trace);
    }

    public static String getTrace(Material material) {
        return materialRegisteredByMod.get(material.identifier);
    }

    private static void error(String message, Object ... params) {
        throw new TinkerAPIException(String.format(message, params));
    }

    static {
        modifiers = new THashMap();
        meltingRegistry = Lists.newLinkedList();
        tableCastRegistry = Lists.newLinkedList();
        basinCastRegistry = Lists.newLinkedList();
        alloyRegistry = Lists.newLinkedList();
        smelteryFuels = Maps.newHashMap();
        entityMeltingRegistry = Maps.newHashMap();
        dryingRegistry = Lists.newLinkedList();
    }
}

