/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.tconstruct.library.book.ElementListingLeft;
import slimeknights.tconstruct.library.book.TinkerPage;

public class ContentListing
extends TinkerPage {
    public String title;
    private final List<TextData> entries = Lists.newArrayList();

    public void addEntry(String text, PageData link) {
        TextData data = new TextData(text);
        if (link != null) {
            data.action = "go-to-page-rtn:" + link.parent.name + "." + link.name;
        }
        this.entries.add(data);
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int yOff = 0;
        if (this.title != null) {
            this.addTitle(list, this.title, false);
            yOff = 20;
        }
        int y = yOff;
        int x = 0;
        int w = GuiBook.PAGE_WIDTH;
        int line_height = 9;
        int bot = GuiBook.PAGE_HEIGHT - 30;
        if (this.entries.size() * line_height + yOff > bot) {
            w /= 2;
        }
        for (TextData data : this.entries) {
            list.add((BookElement)new ElementListingLeft(x, y, w, line_height, data));
            if ((y += line_height) <= bot) continue;
            x += w;
            y = yOff;
        }
    }
}

