/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.lwjgl.util.Point;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.MaterialGUI;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;

public class ToolBuildGuiInfo {
    public static final Material[] RenderMaterials = new Material[4];
    public final ItemStack tool;
    public final List<Point> positions = Lists.newArrayList();

    public ToolBuildGuiInfo() {
        this.tool = null;
    }

    public ToolBuildGuiInfo(TinkersItem tool) {
        LinkedList mats = Lists.newLinkedList();
        for (int i = 0; i < tool.getRequiredComponents().size(); ++i) {
            mats.add(RenderMaterials[i % RenderMaterials.length]);
        }
        this.tool = tool.buildItemForRendering(mats);
    }

    public static ToolBuildGuiInfo default3Part(TinkersItem tool) {
        ToolBuildGuiInfo info = new ToolBuildGuiInfo(tool);
        info.addSlotPosition(13, 62);
        info.addSlotPosition(53, 22);
        info.addSlotPosition(33, 42);
        return info;
    }

    public void addSlotPosition(int x, int y) {
        this.positions.add(new Point(x, y));
    }

    static {
        ToolBuildGuiInfo.RenderMaterials[0] = new MaterialGUI("_internal_render1");
        RenderMaterials[0].setRenderInfo(6835742);
        ToolBuildGuiInfo.RenderMaterials[1] = new MaterialGUI("_internal_render2");
        RenderMaterials[1].setRenderInfo(0xC1C1C1);
        ToolBuildGuiInfo.RenderMaterials[2] = new MaterialGUI("_internal_render3");
        RenderMaterials[2].setRenderInfo(2324189);
        ToolBuildGuiInfo.RenderMaterials[3] = new MaterialGUI("_internal_render4");
        RenderMaterials[3].setRenderInfo(7423664);
        for (Material mat : RenderMaterials) {
            TinkerRegistry.addMaterial(mat);
        }
        TinkerRegistry.tabTools.setDisplayIcon(TinkerHarvestTools.pickaxe.buildItemForRendering((List<Material>)ImmutableList.of((Object)((Object)RenderMaterials[0]), (Object)((Object)RenderMaterials[1]), (Object)((Object)RenderMaterials[2]))));
        TinkerRegistry.tabParts.setDisplayIcon(TinkerTools.pickHead.getItemstackWithMaterial(RenderMaterials[2]));
    }
}

