/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.mantle.client.model.TRSRBakedModel;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.BakedToolModel;
import slimeknights.tconstruct.library.client.model.BakedToolModelOverride;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.format.AmmoPosition;
import slimeknights.tconstruct.library.tools.IAmmoUser;

public class BakedBowModel
extends BakedToolModel {
    protected final AmmoPosition ammoPosition;

    public BakedBowModel(IBakedModel parent, BakedMaterialModel[] parts, BakedMaterialModel[] brokenParts, Map<String, IBakedModel> modifierParts, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform, ImmutableList<BakedToolModelOverride> overrides, AmmoPosition ammoPosition) {
        super(parent, parts, brokenParts, modifierParts, transform, overrides);
        this.ammoPosition = ammoPosition;
    }

    @Override
    @Nonnull
    public ItemOverrideList func_188617_f() {
        return BowItemOverrideList.INSTANCE;
    }

    protected static class BowItemOverrideList
    extends BakedToolModel.ToolItemOverrideList {
        static BowItemOverrideList INSTANCE = new BowItemOverrideList();

        protected BowItemOverrideList() {
        }

        @Override
        protected void addExtraQuads(ItemStack stack, BakedToolModel original, ImmutableList.Builder<BakedQuad> quads, World world, EntityLivingBase entityLivingBase) {
            ItemStack ammo;
            if (original instanceof BakedBowModel && stack.func_77973_b() instanceof IAmmoUser && (ammo = ((IAmmoUser)stack.func_77973_b()).getAmmoToRender(stack, entityLivingBase)) != null) {
                AmmoPosition pos = ((BakedBowModel)original).ammoPosition;
                IBakedModel ammoModel = ModelHelper.getBakedModelForItem(ammo, world, entityLivingBase);
                ammoModel = new TRSRBakedModel(ammoModel, pos.pos[0].floatValue(), pos.pos[1].floatValue(), pos.pos[2].floatValue(), pos.rot[0].floatValue() / 180.0f * (float)Math.PI, pos.rot[1].floatValue() / 180.0f * (float)Math.PI, pos.rot[2].floatValue() / 180.0f * (float)Math.PI, 1.0f);
                quads.addAll((Iterable)ammoModel.func_188616_a(null, null, 0L));
            }
        }
    }
}

