/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.DummyModel;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.format.Offset;
import slimeknights.tconstruct.library.tools.IToolPart;

public class MaterialModelLoader
implements ICustomModelLoader {
    public static String EXTENSION = ".tmat";
    private static final Map<ResourceLocation, Set<IToolPart>> partTextureRestriction = Maps.newHashMap();

    public static void addPartMapping(ResourceLocation resourceLocation, IToolPart toolPart) {
        if (!partTextureRestriction.containsKey(resourceLocation)) {
            partTextureRestriction.put(resourceLocation, Sets.newHashSet());
        }
        partTextureRestriction.get(resourceLocation).add(toolPart);
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().endsWith(EXTENSION);
    }

    public IModel loadModel(ResourceLocation modelLocation) {
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return DummyModel.INSTANCE;
        }
        try {
            Offset offset = ModelHelper.loadOffsetFromJson(modelLocation);
            MaterialModel model = new MaterialModel(ModelHelper.loadTextureListFromJson(modelLocation), offset.x, offset.y);
            ResourceLocation originalLocation = MaterialModelLoader.getReducedPath(modelLocation);
            if (partTextureRestriction.containsKey(originalLocation)) {
                for (IToolPart toolPart : partTextureRestriction.get(originalLocation)) {
                    for (ResourceLocation texture : model.getTextures()) {
                        CustomTextureCreator.registerTextureForPart(texture, toolPart);
                    }
                }
            } else {
                CustomTextureCreator.registerTextures(model.getTextures());
            }
            return model;
        }
        catch (IOException e) {
            TinkerRegistry.log.error("Could not load material model {}", new Object[]{modelLocation.toString()});
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
    }

    public static ResourceLocation getReducedPath(ResourceLocation location) {
        String path = location.func_110623_a();
        path = path.substring("models/item/".length());
        return new ResourceLocation(location.func_110624_b(), path);
    }
}

