/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.format;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.deserializer.ItemCameraTransformsDeserializer;
import slimeknights.tconstruct.library.client.deserializer.ItemTransformVec3fDeserializer;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.format.AmmoPosition;
import slimeknights.tconstruct.library.client.model.format.ModelTextureDeserializer;
import slimeknights.tconstruct.library.client.model.format.PredicateDeserializer;
import slimeknights.tconstruct.library.client.model.format.TransformDeserializer;

@SideOnly(value=Side.CLIENT)
public class ToolModelOverride {
    public final ImmutableMap<ResourceLocation, Float> predicates;
    public final ImmutableMap<String, String> textures;
    public final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    public final AmmoPosition ammoPosition;
    public final TIntObjectHashMap<MaterialModel> partModelReplacement = new TIntObjectHashMap();
    public final TIntObjectHashMap<MaterialModel> brokenPartModelReplacement = new TIntObjectHashMap();

    public ToolModelOverride(ImmutableMap<ResourceLocation, Float> predicates, ImmutableMap<String, String> textures, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, AmmoPosition ammoPosition) {
        this.predicates = predicates;
        this.textures = textures;
        this.transforms = transforms;
        this.ammoPosition = ammoPosition;
    }

    public static class ToolModelOverrideDeserializer
    implements JsonDeserializer<ToolModelOverride> {
        public static final ToolModelOverrideDeserializer INSTANCE = new ToolModelOverrideDeserializer();
        public static final Type TYPE = new TypeToken<ToolModelOverride>(){}.getType();
        private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ModelTextureDeserializer.TYPE, (Object)ModelTextureDeserializer.INSTANCE).registerTypeAdapter(PredicateDeserializer.TYPE, (Object)PredicateDeserializer.INSTANCE).registerTypeAdapter(TransformDeserializer.TYPE, (Object)TransformDeserializer.INSTANCE).registerTypeAdapter(ItemCameraTransforms.class, (Object)ItemCameraTransformsDeserializer.INSTANCE).registerTypeAdapter(ItemTransformVec3f.class, (Object)ItemTransformVec3fDeserializer.INSTANCE).registerTypeAdapter(AmmoPosition.AmmoPositionDeserializer.TYPE, (Object)AmmoPosition.AmmoPositionDeserializer.INSTANCE).create();

        public ToolModelOverride deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            ImmutableMap predicates = (ImmutableMap)GSON.fromJson((JsonElement)json, PredicateDeserializer.TYPE);
            ImmutableMap textures = json.get("textures") != null ? ImmutableMap.copyOf((Map)((Map)GSON.fromJson((JsonElement)json, ModelTextureDeserializer.TYPE))) : ImmutableMap.of();
            ImmutableMap transforms = json.get("display") != null ? (ImmutableMap)GSON.fromJson((JsonElement)json, TransformDeserializer.TYPE) : ImmutableMap.of();
            AmmoPosition ammoPosition = (AmmoPosition)GSON.fromJson((JsonElement)json, AmmoPosition.AmmoPositionDeserializer.TYPE);
            return new ToolModelOverride((ImmutableMap<ResourceLocation, Float>)predicates, (ImmutableMap<String, String>)textures, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms, ammoPosition);
        }
    }

    public static class ToolModelOverrideListDeserializer
    implements JsonDeserializer<ImmutableList<ToolModelOverride>> {
        public static final ToolModelOverrideListDeserializer INSTANCE = new ToolModelOverrideListDeserializer();
        public static final Type TYPE = new TypeToken<ImmutableList<ToolModelOverride>>(){}.getType();
        private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ToolModelOverrideDeserializer.TYPE, (Object)ToolModelOverrideDeserializer.INSTANCE).create();

        public ImmutableList<ToolModelOverride> deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonElement texElem = obj.get("overrides");
            if (texElem == null) {
                return ImmutableList.of();
            }
            if (texElem.isJsonObject()) {
                return ImmutableList.of((Object)((ToolModelOverride)GSON.fromJson(texElem, ToolModelOverrideDeserializer.TYPE)));
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement jsonElement : texElem.getAsJsonArray()) {
                builder.add((Object)((ToolModelOverride)GSON.fromJson(jsonElement, ToolModelOverrideDeserializer.TYPE)));
            }
            return builder.build();
        }
    }
}

