/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.events;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.BowCore;

public abstract class TinkerToolEvent
extends TinkerEvent {
    public final ItemStack itemStack;
    public final ToolCore tool;

    public TinkerToolEvent(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.tool = (ToolCore)itemStack.func_77973_b();
    }

    public static class OnBowShoot
    extends TinkerToolEvent {
        public final EntityPlayer entityPlayer;
        public final BowCore bowCore;
        public final ItemStack ammo;
        public final int useTime;
        public int projectileCount = 1;
        public boolean consumeAmmoPerProjectile = true;
        public boolean consumeDurabilityPerProjectile = true;

        public OnBowShoot(ItemStack bow, ItemStack ammo, EntityPlayer entityPlayer, int useTime) {
            super(bow);
            this.bowCore = (BowCore)bow.func_77973_b();
            this.ammo = ammo;
            this.entityPlayer = entityPlayer;
            this.useTime = useTime;
        }

        public static OnBowShoot fireEvent(ItemStack bow, ItemStack ammo, EntityPlayer entityPlayer, int useTime) {
            OnBowShoot event = new OnBowShoot(bow, ammo, entityPlayer, useTime);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event;
        }

        public void setProjectileCount(int projectileCount) {
            this.projectileCount = projectileCount;
        }

        public void setConsumeAmmoPerProjectile(boolean consumeAmmoPerProjectile) {
            this.consumeAmmoPerProjectile = consumeAmmoPerProjectile;
        }

        public void setConsumeDurabilityPerProjectile(boolean consumeDurabilityPerProjectile) {
            this.consumeDurabilityPerProjectile = consumeDurabilityPerProjectile;
        }
    }

    public static class OnShovelMakePath
    extends TinkerToolEvent {
        public final BlockPos pos;
        public final EntityPlayer player;
        private final World world;

        public OnShovelMakePath(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos) {
            super(itemStack);
            this.pos = pos;
            this.player = player;
            this.world = world;
        }

        public static void fireEvent(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos) {
            MinecraftForge.EVENT_BUS.post((Event)new OnShovelMakePath(itemStack, player, world, pos));
        }
    }

    public static class OnMattockHoe
    extends TinkerToolEvent {
        public final BlockPos pos;
        public final World world;
        public final EntityPlayer player;

        public OnMattockHoe(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos) {
            super(itemStack);
            this.player = player;
            this.pos = pos;
            this.world = world;
        }

        public static void fireEvent(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos) {
            MinecraftForge.EVENT_BUS.post((Event)new OnMattockHoe(itemStack, player, world, pos));
        }
    }

    public static class OnRepair
    extends TinkerToolEvent {
        public final int amount;

        public OnRepair(ItemStack itemStack, int amount) {
            super(itemStack);
            this.amount = amount;
        }

        public static boolean fireEvent(ItemStack itemStack, int amount) {
            OnRepair event = new OnRepair(itemStack, amount);
            return !MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Cancelable
    public static class ExtraBlockBreak
    extends TinkerToolEvent {
        public final EntityPlayer player;
        public final IBlockState state;
        public int width;
        public int height;
        public int depth;
        public int distance;

        public ExtraBlockBreak(ItemStack itemStack, EntityPlayer player, IBlockState state) {
            super(itemStack);
            this.player = player;
            this.state = state;
        }

        public static ExtraBlockBreak fireEvent(ItemStack itemStack, EntityPlayer player, IBlockState state, int width, int height, int depth, int distance) {
            ExtraBlockBreak event = new ExtraBlockBreak(itemStack, player, state);
            event.width = width;
            event.height = height;
            event.depth = depth;
            event.distance = distance;
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event;
        }
    }
}

