/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public class FluidTankAnimated
extends FluidTank {
    public float renderOffset;
    private final TileEntity parent;

    public FluidTankAnimated(int capacity, TileEntity parent) {
        super(capacity);
        this.parent = parent;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = super.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.sendUpdate(amount);
        }
        return amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack fluid = super.drain(resource, doDrain);
        if (fluid != null && doDrain) {
            this.sendUpdate(-fluid.amount);
        }
        return fluid;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack fluid = super.drain(maxDrain, doDrain);
        if (fluid != null && doDrain) {
            this.sendUpdate(-fluid.amount);
        }
        return fluid;
    }

    protected void sendUpdate(int amount) {
        if (amount != 0) {
            this.renderOffset += (float)amount;
            World world = this.parent.func_145831_w();
            if (!world.field_72995_K && world instanceof WorldServer) {
                TinkerNetwork.sendToClients((WorldServer)world, this.parent.func_174877_v(), (AbstractPacket)new FluidUpdatePacket(this.parent.func_174877_v(), this.getFluid()));
            }
        }
    }

    protected void onContentsChanged() {
        if (this.parent instanceof IFluidTankUpdater) {
            ((IFluidTankUpdater)this.parent).onTankContentsChanged();
        }
    }
}

