/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.ImmutableList;
import java.util.List;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;

public class FletchingMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Accuracy = "stat.fletching.accuracy.name";
    public static final String LOC_Multiplier = "stat.fletching.modifier.name";
    public static final String LOC_AccuracyDesc = "stat.fletching.accuracy.desc";
    public static final String LOC_MultiplierDesc = "stat.fletching.modifier.desc";
    public static final String COLOR_Accuracy = CustomFontColor.encodeColor(205, 170, 205);
    public static final String COLOR_Modifier = HandleMaterialStats.COLOR_Modifier;
    public final float modifier;
    public final float accuracy;

    public FletchingMaterialStats(float accuracy, float modifier) {
        super("fletching");
        this.accuracy = accuracy;
        this.modifier = modifier;
    }

    @Override
    public List<String> getLocalizedInfo() {
        return ImmutableList.of((Object)FletchingMaterialStats.formatModifier(this.modifier), (Object)FletchingMaterialStats.formatAccuracy(this.accuracy));
    }

    @Override
    public List<String> getLocalizedDesc() {
        return ImmutableList.of((Object)Util.translate(LOC_MultiplierDesc, new Object[0]), (Object)Util.translate(LOC_AccuracyDesc, new Object[0]));
    }

    public static String formatModifier(float quality) {
        return FletchingMaterialStats.formatNumber(LOC_Multiplier, COLOR_Modifier, quality);
    }

    public static String formatAccuracy(float accuraccy) {
        return FletchingMaterialStats.formatNumberPercent(LOC_Accuracy, COLOR_Accuracy, accuraccy);
    }
}

