/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.ImmutableList;
import java.util.List;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;

public class HandleMaterialStats
extends AbstractMaterialStats {
    @Deprecated
    public static final String TYPE = "handle";
    public static final String LOC_Multiplier = "stat.handle.modifier.name";
    public static final String LOC_Durability = "stat.handle.durability.name";
    public static final String LOC_MultiplierDesc = "stat.handle.modifier.desc";
    public static final String LOC_DurabilityDesc = "stat.handle.durability.desc";
    public static final String COLOR_Durability = HeadMaterialStats.COLOR_Durability;
    public static final String COLOR_Modifier = CustomFontColor.encodeColor(205, 205, 100);
    public final float modifier;
    public final int durability;

    public HandleMaterialStats(float modifier, int durability) {
        super(TYPE);
        this.durability = durability;
        this.modifier = modifier;
    }

    @Override
    public List<String> getLocalizedInfo() {
        return ImmutableList.of((Object)HandleMaterialStats.formatModifier(this.modifier), (Object)HandleMaterialStats.formatDurability(this.durability));
    }

    @Override
    public List<String> getLocalizedDesc() {
        return ImmutableList.of((Object)Util.translate(LOC_MultiplierDesc, new Object[0]), (Object)Util.translate(LOC_DurabilityDesc, new Object[0]));
    }

    public static String formatModifier(float quality) {
        return HandleMaterialStats.formatNumber(LOC_Multiplier, COLOR_Modifier, quality);
    }

    public static String formatDurability(int durability) {
        return HandleMaterialStats.formatNumber(LOC_Durability, COLOR_Durability, durability);
    }
}

