/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ProjectileLauncherNBT
extends ToolNBT {
    public float drawSpeed;
    public float range;

    public ProjectileLauncherNBT() {
        this.drawSpeed = 1.0f;
        this.range = 1.0f;
    }

    public ProjectileLauncherNBT(NBTTagCompound tag) {
        super(tag);
    }

    public ProjectileLauncherNBT limb(BowMaterialStats ... bowlimbs) {
        this.drawSpeed = 0.0f;
        this.range = 0.0f;
        for (BowMaterialStats limb : bowlimbs) {
            if (limb == null) continue;
            this.drawSpeed += limb.drawspeed;
            this.range += limb.range;
        }
        this.drawSpeed /= (float)bowlimbs.length;
        this.range /= (float)bowlimbs.length;
        this.drawSpeed = Math.max(0.001f, this.drawSpeed);
        this.range = Math.max(0.001f, this.range);
        return this;
    }

    public ProjectileLauncherNBT bowstring(BowStringMaterialStats ... bowstrings) {
        float modifier = 0.0f;
        for (BowStringMaterialStats bowstring : bowstrings) {
            if (bowstring == null) continue;
            modifier += bowstring.modifier;
        }
        this.durability = Math.round((float)this.durability * (modifier /= (float)bowstrings.length));
        this.durability = Math.max(1, this.durability);
        return this;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        this.drawSpeed = tag.func_74760_g("DrawSpeed");
        this.range = tag.func_74760_g("Range");
    }

    @Override
    public void write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74776_a("DrawSpeed", this.drawSpeed);
        tag.func_74776_a("Range", this.range);
    }

    public static ProjectileLauncherNBT from(ItemStack itemStack) {
        return new ProjectileLauncherNBT(TagUtil.getToolTag(itemStack));
    }
}

