/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeHandler;
import slimeknights.tconstruct.plugin.jei.CastingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.CastingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.CastingRecipeWrapper;
import slimeknights.tconstruct.plugin.jei.CraftingStationRecipeTransferInfo;
import slimeknights.tconstruct.plugin.jei.DryingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.DryingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.SmeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.SmeltingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.TableRecipeHandler;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationRecipeTransferInfo());
            registry.addRecipeCategoryCraftingItem(new ItemStack((Block)TinkerTools.toolTables, 1, BlockToolTable.TableTypes.CraftingStation.meta), new String[]{"minecraft.crafting"});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            CastingRecipe recipe;
            CastingRecipeCategory castingCategory = new CastingRecipeCategory(guiHelper);
            registry.addRecipeCategories(new IRecipeCategory[]{new SmeltingRecipeCategory(guiHelper), new AlloyRecipeCategory(guiHelper), castingCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new TableRecipeHandler(), new SmeltingRecipeHandler(), new AlloyRecipeHandler(), new CastingRecipeHandler()});
            registry.addRecipeCategoryCraftingItem(new ItemStack((Block)TinkerSmeltery.smelteryController), new String[]{SmeltingRecipeCategory.CATEGORY, AlloyRecipeCategory.CATEGORY});
            registry.addRecipeCategoryCraftingItem(new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.TABLE.meta), new String[]{CastingRecipeCategory.CATEGORY});
            registry.addRecipeCategoryCraftingItem(new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.BASIN.meta), new String[]{CastingRecipeCategory.CATEGORY});
            registry.addRecipeCategoryCraftingItem(new ItemStack(TinkerSmeltery.searedFurnaceController), new String[]{"minecraft.smelting"});
            registry.addRecipes(TinkerRegistry.getAllMeltingRecipies());
            registry.addRecipes(TinkerRegistry.getAlloys());
            HashMap castDict = Maps.newHashMap();
            for (ICastingRecipe irecipe : TinkerRegistry.getAllTableCastingRecipes()) {
                if (!(irecipe instanceof CastingRecipe)) continue;
                recipe = (CastingRecipe)irecipe;
                if (recipe.cast != null && recipe.getResult() != null && recipe.getResult().func_77973_b() instanceof Cast) {
                    Triple output = Triple.of((Object)recipe.getResult().func_77973_b(), (Object)Cast.getPartFromTag(recipe.getResult()), (Object)recipe.getFluid().getFluid());
                    if (!castDict.containsKey(output)) {
                        LinkedList list = Lists.newLinkedList();
                        castDict.put(output, list);
                        registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(list, recipe, castingCategory.castingTable))));
                    }
                    ((List)castDict.get(output)).addAll(recipe.cast.getInputs());
                    continue;
                }
                registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(recipe, castingCategory.castingTable))));
            }
            for (ICastingRecipe irecipe : TinkerRegistry.getAllBasinCastingRecipes()) {
                if (!(irecipe instanceof CastingRecipe)) continue;
                recipe = (CastingRecipe)irecipe;
                registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(recipe, castingCategory.castingBasin))));
            }
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new DryingRecipeCategory(guiHelper)});
            registry.addRecipeHandlers(new IRecipeHandler[]{new DryingRecipeHandler()});
            registry.addRecipes(TinkerRegistry.getAllDryingRecipes());
            registry.addRecipeCategoryCraftingItem(BlockTable.createItemstack(TinkerGadgets.rack, 1, (Block)Blocks.field_150376_bx, 0), new String[]{DryingRecipeCategory.CATEGORY});
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
    }
}

