/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.smeltery.tileentity.TileCasting;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingBasin;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingTable;

public class CastingRenderer<T extends TileCasting>
extends TileEntitySpecialRenderer<T> {
    protected final float yMin;
    protected final float yMax;
    protected final float xzMin;
    protected final float xzMax;
    protected float yScale;
    protected float xzScale;
    protected float yOffset;
    protected float xzOffset;

    public CastingRenderer(float yMin, float yMax, float xzMin, float xzMax) {
        float s = 0.9995f;
        this.yMin = yMin * s;
        this.yMax = yMax * s;
        this.xzMin = xzMin * s;
        this.xzMax = xzMax * s;
        this.yOffset = yMin + (yMax - yMin) / 2.0f;
        this.xzOffset = xzMin + (xzMax - xzMin) / 2.0f;
        this.yScale = this.xzScale = this.xzMax - this.xzMin;
    }

    public void renderTileEntityAt(@Nonnull T te, double x, double y, double z, float partialTicks, int destroyStage) {
        FluidTankAnimated tank = ((TileCasting)te).tank;
        if (tank.getFluidAmount() == 0 || tank.getCapacity() == 0) {
            return;
        }
        float height = ((float)tank.getFluidAmount() - tank.renderOffset) / (float)tank.getCapacity();
        tank.renderOffset = tank.renderOffset > 1.2f || tank.renderOffset < -1.2f ? (tank.renderOffset -= (tank.renderOffset / 12.0f + 0.1f) * partialTicks) : 0.0f;
        float yh = this.yMin + (this.yMax - this.yMin) * height;
        FluidStack fluid = tank.getFluid();
        float progress = 0.0f;
        progress = ((TileCasting)te).getProgress();
        int color = fluid.getFluid().getColor(fluid);
        int a = RenderUtil.alpha(color);
        int r = RenderUtil.red(color);
        int g = RenderUtil.green(color);
        int b = RenderUtil.blue(color);
        if (progress > 0.0f) {
            float af = progress / 3.0f;
            a = (int)((float)a / 255.0f * (1.0f - af) * (float)a);
            color = RenderUtil.compose(r, g, b, a);
        }
        RenderUtil.renderFluidCuboid(tank.getFluid(), te.func_174877_v(), x, y, z, this.xzMin, this.yMin, this.xzMin, this.xzMax, yh, this.xzMax, color);
        ItemStack stack = ((TileCasting)te).getCurrentResult();
        if (progress > 0.0f && stack != null && te.func_70301_a(1) == null) {
            RenderUtil.pre(x, y, z);
            int brightness = te.func_145831_w().func_175626_b(te.func_174877_v(), 0);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)(brightness % 65536) / 1.0f), (float)((float)(brightness / 65536) / 1.0f));
            GlStateManager.func_179109_b((float)this.xzOffset, (float)this.yOffset, (float)this.xzOffset);
            GlStateManager.func_179152_a((float)this.xzScale, (float)this.yScale, (float)this.xzScale);
            GlStateManager.func_179114_b((float)(-90 * ((TileTable)((Object)te)).getFacing().func_176736_b()), (float)0.0f, (float)1.0f, (float)0.0f);
            if (!(stack.func_77973_b() instanceof ItemBlock)) {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179112_b((int)32771, (int)32772);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)progress);
            GL11.glDepthMask((boolean)false);
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, te.func_145831_w(), null);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
            GL11.glDepthMask((boolean)true);
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderUtil.post();
        }
    }

    public static class Basin
    extends CastingRenderer<TileCastingBasin> {
        public Basin() {
            super(0.25f, 1.0f, 0.125f, 0.875f);
            this.xzScale = 0.751f;
        }
    }

    public static class Table
    extends CastingRenderer<TileCastingTable> {
        public Table() {
            super(0.9375f, 1.001f, 0.0625f, 0.9375f);
            this.xzScale = 0.875f;
            this.yScale = 1.0f;
            this.yOffset += 0.001f;
        }
    }
}

